/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.concurrent;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.concurrent.PrioritisedRunnable;
import org.jbpm.executor.impl.concurrent.PrioritisedScheduledThreadPoolExecutor;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.RequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAndScheduleRequestsTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LoadAndScheduleRequestsTask.class);
    private ExecutorStoreService executorStoreService;
    private ScheduledExecutorService scheduler;
    private AvailableJobsExecutor jobProcessor;

    public LoadAndScheduleRequestsTask(ExecutorStoreService executorStoreService, ScheduledExecutorService scheduler, AvailableJobsExecutor jobProcessor) {
        this.executorStoreService = executorStoreService;
        this.scheduler = scheduler;
        this.jobProcessor = jobProcessor;
    }

    @Override
    public void run() {
        try {
            logger.info("Load of jobs from storage started at {}", (Object)new Date());
            List loaded = this.executorStoreService.loadRequests();
            if (!loaded.isEmpty()) {
                logger.info("Found {} jobs that are waiting for execution, scheduling them...", (Object)loaded.size());
                int scheduledCounter = 0;
                for (RequestInfo request : loaded) {
                    PrioritisedRunnable job = new PrioritisedRunnable(request.getId(), request.getPriority(), request.getTime(), this.jobProcessor);
                    long delay = request.getTime().getTime() - System.currentTimeMillis();
                    logger.debug("Scheduling with delay {} for request {}", (Object)delay, (Object)request.getId());
                    boolean scheduled = ((PrioritisedScheduledThreadPoolExecutor)this.scheduler).scheduleNoDuplicates(job, delay, TimeUnit.MILLISECONDS);
                    if (scheduled) {
                        logger.debug("Request {} has been successfully scheduled", (Object)request.getId());
                        ++scheduledCounter;
                        continue;
                    }
                    logger.debug("Request {} has not been scheduled as it's already there", (Object)request.getId());
                }
                logger.info("{} jobs have been successfully scheduled", (Object)scheduledCounter);
            }
            logger.info("Load of jobs from storage finished at {}", (Object)new Date());
        }
        catch (Throwable e) {
            logger.error("Unexpected error while synchronizing with data base for jobs", e);
        }
    }
}

