/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.MarshallingConfigurationImpl;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.serialization.protobuf.PersisterHelper;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMessages;
import org.drools.serialization.protobuf.ProtobufProcessMarshallerWriteContext;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProtobufProcessMarshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.AccessType;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.FaultData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMarshallerHelper {
    private static final Logger logger = LoggerFactory.getLogger(ContentMarshallerHelper.class);
    private static final String SINGLE_VAR_KEY = "_results_";

    public static ContentData marshal(Object o, Environment env) {
        return ContentMarshallerHelper.marshal(null, o, env);
    }

    public static ContentData marshal(Task task, Object o, Environment env) {
        if (o == null) {
            return null;
        }
        ContentData content = null;
        byte[] toByteArray = ContentMarshallerHelper.marshallContent(task, o, env);
        content = TaskModelProvider.getFactory().newContentData();
        content.setContent(toByteArray);
        content.setType(o.getClass().getCanonicalName());
        content.setAccessType(AccessType.Inline);
        return content;
    }

    public static FaultData marshalFault(Map<String, Object> fault, Environment env) {
        return ContentMarshallerHelper.marshalFault(null, fault, env);
    }

    public static FaultData marshalFault(Task task, Map<String, Object> fault, Environment env) {
        FaultData content = null;
        byte[] toByteArray = ContentMarshallerHelper.marshallContent(task, fault, env);
        content = TaskModelProvider.getFactory().newFaultData();
        content.setContent(toByteArray);
        content.setType(fault.getClass().getCanonicalName());
        content.setAccessType(AccessType.Inline);
        content.setFaultName((String)fault.get("faultName"));
        content.setType((String)fault.get("faultType"));
        return content;
    }

    public static Object unmarshall(byte[] content, Environment env) {
        return ContentMarshallerHelper.unmarshall(content, env, null);
    }

    public static Object unmarshall(byte[] content, Environment env, ClassLoader classloader) {
        ProtobufMarshallerReaderContext context = null;
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        MarshallingConfigurationImpl marshallingConfigurationImpl = null;
        marshallingConfigurationImpl = env != null ? new MarshallingConfigurationImpl((ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies"), false, false) : new MarshallingConfigurationImpl(new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)}, false, false);
        ObjectMarshallingStrategyStore objectMarshallingStrategyStore = marshallingConfigurationImpl.getObjectMarshallingStrategyStore();
        context = new ProtobufMarshallerReaderContext((InputStream)stream, null, null, objectMarshallingStrategyStore, null, env);
        if (classloader != null) {
            context.setClassLoader(classloader);
        } else {
            context.setClassLoader(ContentMarshallerHelper.class.getClassLoader());
        }
        ExtensionRegistry registry = PersisterHelper.buildRegistry((MarshallerReaderContext)context, null);
        ProtobufMessages.Header _header = PersisterHelper.readFromStreamWithHeaderPreloaded((MarshallerReaderContext)context, (ExtensionRegistry)registry);
        try {
            JBPMMessages.VariableContainer parseFrom = JBPMMessages.VariableContainer.parseFrom((ByteString)_header.getPayload(), (ExtensionRegistryLite)registry);
            Map value = ProtobufProcessMarshaller.unmarshallVariableContainerValue((MarshallerReaderContext)context, (JBPMMessages.VariableContainer)parseFrom);
            if (value.containsKey(SINGLE_VAR_KEY) && value.size() == 1) {
                return value.get(SINGLE_VAR_KEY);
            }
            return value;
        }
        catch (Exception e) {
            try {
                return ContentMarshallerHelper.fallbackParse((MarshallerReaderContext)context, _header, registry);
            }
            catch (Exception ex) {
                logger.warn("Exception while unmarshaling content", (Throwable)ex);
                return null;
            }
        }
    }

    public static byte[] marshallContent(Object o, Environment env) {
        return ContentMarshallerHelper.marshallContent(null, o, env);
    }

    public static byte[] marshallContent(Task task, Object o, Environment env) {
        try {
            MarshallingConfigurationImpl marshallingConfigurationImpl = null;
            marshallingConfigurationImpl = env != null ? new MarshallingConfigurationImpl((ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies"), false, false) : new MarshallingConfigurationImpl(new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)}, false, false);
            ObjectMarshallingStrategyStore objectMarshallingStrategyStore = marshallingConfigurationImpl.getObjectMarshallingStrategyStore();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ProtobufProcessMarshallerWriteContext context = new ProtobufProcessMarshallerWriteContext((OutputStream)stream, null, null, null, objectMarshallingStrategyStore, env);
            if (task != null) {
                context.setTaskId(task.getId());
                context.setProcessInstanceId(Long.valueOf(task.getTaskData().getProcessInstanceId()));
                context.setWorkItemId(Long.valueOf(task.getTaskData().getWorkItemId()));
                int taskState = 1;
                if (task.getTaskData().getStatus() == Status.Completed || task.getTaskData().getStatus() == Status.Error || task.getTaskData().getStatus() == Status.Exited || task.getTaskData().getStatus() == Status.Failed || task.getTaskData().getStatus() == Status.Obsolete) {
                    taskState = 2;
                }
                context.setState(taskState);
            }
            HashMap<String, Object> input = null;
            if (o instanceof Map) {
                input = (HashMap<String, Object>)o;
            } else {
                input = new HashMap<String, Object>();
                input.put(SINGLE_VAR_KEY, o);
            }
            JBPMMessages.VariableContainer marshallVariable = ProtobufProcessMarshaller.marshallVariablesContainer((MarshallerWriteContext)context, input);
            PersisterHelper.writeToStreamWithHeader((MarshallerWriteContext)context, (Message)marshallVariable);
            context.close();
            return stream.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Object fallbackParse(MarshallerReaderContext context, ProtobufMessages.Header header, ExtensionRegistry registry) throws Exception {
        JBPMMessages.Variable parseFrom = JBPMMessages.Variable.parseFrom((ByteString)header.getPayload(), (ExtensionRegistryLite)registry);
        Object value = ProtobufProcessMarshaller.unmarshallVariableValue((MarshallerReaderContext)context, (JBPMMessages.Variable)parseFrom);
        if (value instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map variablesMap = (Map)value;
            for (String key : variablesMap.keySet()) {
                result.put(key, ProtobufProcessMarshaller.unmarshallVariableValue((MarshallerReaderContext)context, (JBPMMessages.Variable)((JBPMMessages.Variable)variablesMap.get(key))));
            }
            return result;
        }
        return value;
    }
}

