/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.transformation;

import java.util.Map;
import java.util.Set;
import org.drools.mvel.MVELSafeHelper;
import org.kie.api.runtime.process.DataTransformer;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELDataTransformer
implements DataTransformer {
    private static final Logger logger = LoggerFactory.getLogger(MVELDataTransformer.class);

    public Object compile(String expression, Map<String, Object> parameters) {
        Set imports;
        logger.debug("About to compile mvel expression {}", (Object)expression);
        ClassLoader classLoader = (ClassLoader)parameters.get("classloader");
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ParserConfiguration config = new ParserConfiguration();
        config.setClassLoader(classLoader);
        ParserContext context = new ParserContext(config);
        if (parameters != null && (imports = (Set)parameters.get("imports")) != null) {
            for (String clazz : imports) {
                try {
                    Class<?> cl = Class.forName(clazz, true, classLoader);
                    context.addImport(cl.getSimpleName(), cl);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Unable to load class {} due to {}", (Object)clazz, (Object)e.getException());
                }
            }
        }
        return MVEL.compileExpression((String)expression, (ParserContext)context);
    }

    public Object transform(Object expression, Map<String, Object> parameters) {
        logger.debug("About to execute mvel expression {} with parameters {}", expression, parameters);
        return MVELSafeHelper.getEvaluator().executeExpression(expression, parameters);
    }
}

