/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.BytecodeDisassembler;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledST {
    public String name;
    public String prefix = "/";
    public String template = "";
    public Token templateDefStartToken;
    public TokenStream tokens;
    public CommonTree ast;
    public Map<String, FormalArgument> formalArguments;
    public boolean hasFormalArgs;
    public int numberOfArgsWithDefaultValues;
    public List<CompiledST> implicitlyDefinedTemplates;
    public STGroup nativeGroup = STGroup.defaultGroup;
    public boolean isRegion;
    public ST.RegionType regionDefType;
    public boolean isAnonSubtemplate;
    public String[] strings;
    public byte[] instrs = new byte[15];
    public int codeSize;
    public Interval[] sourceMap = new Interval[15];

    public void addImplicitlyDefinedTemplate(CompiledST sub) {
        sub.prefix = this.prefix;
        if (sub.name.charAt(0) != '/') {
            sub.name = sub.prefix + sub.name;
        }
        if (this.implicitlyDefinedTemplates == null) {
            this.implicitlyDefinedTemplates = new ArrayList<CompiledST>();
        }
        this.implicitlyDefinedTemplates.add(sub);
    }

    public void defineArgDefaultValueTemplates(STGroup group) {
        if (this.formalArguments == null) {
            return;
        }
        block7: for (String a : this.formalArguments.keySet()) {
            FormalArgument fa = this.formalArguments.get(a);
            if (fa.defaultValueToken == null) continue;
            ++this.numberOfArgsWithDefaultValues;
            switch (fa.defaultValueToken.getType()) {
                case 4: {
                    String argSTname = fa.name + "_default_value";
                    Compiler c2 = new Compiler(group);
                    String defArgTemplate = Misc.strip(fa.defaultValueToken.getText(), 1);
                    fa.compiledDefaultValue = c2.compile(group.getFileName(), argSTname, null, defArgTemplate, fa.defaultValueToken);
                    fa.compiledDefaultValue.name = argSTname;
                    fa.compiledDefaultValue.defineImplicitlyDefinedTemplates(group);
                    continue block7;
                }
                case 13: {
                    fa.defaultValue = Misc.strip(fa.defaultValueToken.getText(), 1);
                    continue block7;
                }
                case 10: {
                    fa.defaultValue = Collections.emptyList();
                    continue block7;
                }
                case 14: {
                    fa.defaultValue = fa.defaultValueToken.getType() == 14;
                    continue block7;
                }
                case 8: {
                    fa.defaultValue = fa.defaultValueToken.getType() == 14;
                    continue block7;
                }
            }
            throw new UnsupportedOperationException("Unexpected default value token type.");
        }
    }

    public void defineFormalArgs(List<FormalArgument> args) {
        this.hasFormalArgs = true;
        if (args == null) {
            this.formalArguments = null;
        } else {
            for (FormalArgument a : args) {
                this.addArg(a);
            }
        }
    }

    public void addArg(FormalArgument a) {
        if (this.formalArguments == null) {
            this.formalArguments = Collections.synchronizedMap(new LinkedHashMap());
        }
        a.index = this.formalArguments.size();
        this.formalArguments.put(a.name, a);
    }

    public void defineImplicitlyDefinedTemplates(STGroup group) {
        if (this.implicitlyDefinedTemplates != null) {
            for (CompiledST sub : this.implicitlyDefinedTemplates) {
                group.rawDefineTemplate(sub.name, sub, sub.templateDefStartToken);
                sub.defineImplicitlyDefinedTemplates(group);
            }
        }
    }

    public String getTemplateSource() {
        Interval r = this.getTemplateRange();
        return this.template.substring(r.a, r.b + 1);
    }

    public Interval getTemplateRange() {
        if (this.isAnonSubtemplate) {
            int start = Integer.MAX_VALUE;
            int stop = Integer.MIN_VALUE;
            for (Interval interval : this.sourceMap) {
                if (interval == null) continue;
                start = Math.min(start, interval.a);
                stop = Math.max(stop, interval.b);
            }
            if (start <= stop + 1) {
                return new Interval(start, stop);
            }
        }
        return new Interval(0, this.template.length() - 1);
    }

    public String instrs() {
        BytecodeDisassembler dis = new BytecodeDisassembler(this);
        return dis.instrs();
    }

    public void dump() {
        BytecodeDisassembler dis = new BytecodeDisassembler(this);
        System.out.println(this.name + ":");
        System.out.println(dis.disassemble());
        System.out.println("Strings:");
        System.out.println(dis.strings());
        System.out.println("Bytecode to template map:");
        System.out.println(dis.sourceMap());
    }

    public String disasm() {
        BytecodeDisassembler dis = new BytecodeDisassembler(this);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(dis.disassemble());
        pw.println("Strings:");
        pw.println(dis.strings());
        pw.println("Bytecode to template map:");
        pw.println(dis.sourceMap());
        pw.close();
        return sw.toString();
    }
}

