/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Map;
import org.drools.core.common.DroolsObjectInputStream;
import org.jbpm.document.Document;
import org.jbpm.document.marshalling.AbstractDocumentMarshallingStrategy;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.DocumentStorageServiceProvider;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class DocumentMarshallingStrategy
extends AbstractDocumentMarshallingStrategy {
    private DocumentStorageService documentStorageService;

    public DocumentMarshallingStrategy() {
        this.documentStorageService = DocumentStorageServiceProvider.get().getStorageService();
    }

    public DocumentMarshallingStrategy(String path) {
        this.documentStorageService = DocumentStorageServiceProvider.get().getStorageService();
    }

    public DocumentMarshallingStrategy(DocumentStorageService documentStorageService) {
        this.documentStorageService = documentStorageService;
    }

    @Override
    public Document buildDocument(String name, long size, Date lastModified, Map<String, String> params) {
        return this.documentStorageService.buildDocument(name, size, lastModified, params);
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        throw new UnsupportedOperationException("write is not supported anymore, use marshal instead");
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("read is not supported anymore, use unmarshal instead");
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream objectOutputStream, Object o) throws IOException {
        Document document = (Document)o;
        String updatedAttribute = document.getAttribute("_UPDATED_");
        if (Boolean.parseBoolean(updatedAttribute)) {
            this.documentStorageService.saveDocument(document, document.getContent());
            document.addAttribute("_UPDATED_", "false");
        } else if (document.getIdentifier() == null || this.documentStorageService.getDocument(document.getIdentifier()) == null) {
            this.documentStorageService.saveDocument(document, document.getContent());
            document.addAttribute("_UPDATED_", "false");
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buff);
        oos.writeUTF(document.getIdentifier());
        oos.writeUTF(document.getClass().getCanonicalName());
        oos.writeUTF(document.getLink());
        oos.close();
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream objectInputStream, byte[] object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), classLoader);
        String objectId = is.readUTF();
        String canonicalName = is.readUTF();
        String link = is.readUTF();
        Document storedDoc = null;
        try {
            storedDoc = this.documentStorageService.getDocument(objectId);
            storedDoc.setLink(link);
            storedDoc.addAttribute("_UPDATED_", "false");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read document from storage service", e);
        }
        return storedDoc;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

