/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.impl.AbstractDataSetOp;
import org.dashbuilder.dataset.sort.DataSetSort;

public class DataSetLookup {
    protected String dataSetUUID = null;
    protected int rowOffset = 0;
    protected int numberOfRows = -1;
    protected boolean testMode = false;
    protected List<DataSetOp> operationList = new ArrayList<DataSetOp>();
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public DataSetLookup() {
    }

    public boolean testMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public boolean isEmpty() {
        if (!this.operationList.isEmpty()) {
            return false;
        }
        if (this.numberOfRows > 0) {
            return false;
        }
        return this.rowOffset <= 0;
    }

    public void setDataSetUUID(String dataSetUUID) {
        this.dataSetUUID = dataSetUUID;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        if (rowOffset < 0) {
            throw new IllegalArgumentException("Offset can't be negative: " + rowOffset);
        }
        this.rowOffset = rowOffset;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public DataSetLookup(String dataSetUUID, DataSetOp ... ops) {
        this.dataSetUUID = dataSetUUID;
        for (DataSetOp op : ops) {
            this.operationList.add(op);
        }
    }

    public String getDataSetUUID() {
        return this.dataSetUUID;
    }

    public <T extends DataSetOp> T getOperation(int index) {
        return (T)this.operationList.get(index);
    }

    public <T extends DataSetOp> T removeOperation(int index) {
        return (T)this.operationList.remove(index);
    }

    public int getOperationIdx(DataSetOp op) {
        return this.operationList.indexOf(op);
    }

    public List<DataSetOp> getOperationList() {
        return this.operationList;
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void setMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public <T extends DataSetOp> List<T> getOperationList(Class<T> type) {
        ArrayList<DataSetOp> result = new ArrayList<DataSetOp>();
        for (DataSetOp op : this.operationList) {
            if (!op.getClass().equals(type)) continue;
            result.add(op);
        }
        return result;
    }

    public int removeOperations(DataSetOpType type) {
        int removed = 0;
        Iterator<DataSetOp> it = this.operationList.iterator();
        while (it.hasNext()) {
            DataSetOp op = it.next();
            if (!op.getType().equals((Object)type)) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public DataSetLookup addOperation(int pos, DataSetOp ... ops) {
        for (DataSetOp op : ops) {
            this.operationList.add(pos, op);
            ((AbstractDataSetOp)op).setDataSetUUID(this.dataSetUUID);
        }
        return this;
    }

    public DataSetLookup addOperation(DataSetOp ... ops) {
        for (DataSetOp op : ops) {
            this.operationList.add(op);
            ((AbstractDataSetOp)op).setDataSetUUID(this.dataSetUUID);
        }
        return this;
    }

    public DataSetGroup getLastGroupOp() {
        List<DataSetGroup> ops = this.getOperationList(DataSetGroup.class);
        if (ops.isEmpty()) {
            return null;
        }
        return ops.get(ops.size() - 1);
    }

    public DataSetFilter getFirstFilterOp() {
        List<DataSetFilter> ops = this.getOperationList(DataSetFilter.class);
        if (ops.isEmpty()) {
            return null;
        }
        return ops.get(0);
    }

    public DataSetSort getFirstSortOp() {
        List<DataSetSort> ops = this.getOperationList(DataSetSort.class);
        if (ops.isEmpty()) {
            return null;
        }
        return ops.get(0);
    }

    public int getFirstGroupOpIndex(int fromIndex, String columnId, Boolean onlySelections) {
        for (int i = fromIndex; i < this.operationList.size(); ++i) {
            boolean matchSelections;
            DataSetOp op = this.operationList.get(i);
            if (!DataSetOpType.GROUP.equals((Object)op.getType())) continue;
            DataSetGroup groupOp = (DataSetGroup)op;
            ColumnGroup cg = groupOp.getColumnGroup();
            boolean hasSelections = groupOp.isSelect();
            boolean matchColumn = columnId == null || cg != null && cg.getColumnId().equals(columnId);
            boolean bl = matchSelections = onlySelections == null || onlySelections != false && hasSelections || onlySelections == false && !hasSelections;
            if (!matchColumn || !matchSelections) continue;
            return i;
        }
        return -1;
    }

    public List<DataSetGroup> getFirstGroupOpSelections() {
        ArrayList<DataSetGroup> result = new ArrayList<DataSetGroup>();
        for (DataSetGroup group : this.getOperationList(DataSetGroup.class)) {
            if (!group.isSelect()) break;
            result.add(group);
        }
        return result;
    }

    public int getLastGroupOpIndex(int fromIndex, String columnId, boolean onlySelections) {
        int target = -1;
        for (int i = fromIndex; i < this.operationList.size(); ++i) {
            DataSetGroup groupOp;
            ColumnGroup cg;
            DataSetOp op = this.operationList.get(i);
            if (!DataSetOpType.GROUP.equals((Object)op.getType()) || (cg = (groupOp = (DataSetGroup)op).getColumnGroup()) == null || columnId != null && !cg.getColumnId().equals(columnId) || onlySelections && !groupOp.isSelect()) continue;
            target = i;
        }
        return target;
    }

    public int getLastGroupOpIndex(int fromIndex) {
        int target = -1;
        for (int i = fromIndex; i < this.operationList.size(); ++i) {
            DataSetOp op = this.operationList.get(i);
            if (!DataSetOpType.GROUP.equals((Object)op.getType())) continue;
            target = i;
        }
        return target;
    }

    public DataSetLookup cloneInstance() {
        DataSetLookup clone = new DataSetLookup();
        clone.setDataSetUUID(this.dataSetUUID);
        clone.setRowOffset(this.rowOffset);
        clone.setNumberOfRows(this.numberOfRows);
        for (DataSetOp dataSetOp : this.operationList) {
            clone.operationList.add(dataSetOp.cloneInstance());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        try {
            DataSetLookup other = (DataSetLookup)obj;
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.dataSetUUID == null || other.dataSetUUID == null) {
                return false;
            }
            if (!this.dataSetUUID.equals(other.dataSetUUID)) {
                return false;
            }
            if (this.rowOffset != other.rowOffset) {
                return false;
            }
            if (this.numberOfRows != other.numberOfRows) {
                return false;
            }
            if (this.operationList.size() != other.operationList.size()) {
                return false;
            }
            for (int i = 0; i < this.operationList.size(); ++i) {
                DataSetOp otherOp;
                DataSetOp op = this.operationList.get(i);
                if (op.equals(otherOp = other.operationList.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

