/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.runtime.manager.impl.lock.DefaultRuntimeManagerLockFactory;
import org.jbpm.runtime.manager.impl.lock.RuntimeManagerLockThreadsInfo;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockFactory;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRuntimeManagerLockStrategy
implements RuntimeManagerLockStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRuntimeManagerLockStrategy.class);
    protected Map<Long, RuntimeManagerLockThreadsInfo> engineLocks;
    private RuntimeManagerLockFactory runtimeManagerLockFactory = new DefaultRuntimeManagerLockFactory();

    protected AbstractRuntimeManagerLockStrategy() {
        this.engineLocks = new HashMap<Long, RuntimeManagerLockThreadsInfo>();
    }

    @Override
    public void init(RuntimeManagerLockFactory factory) {
        this.runtimeManagerLockFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Long id, RuntimeEngine runtime) throws InterruptedException {
        RuntimeManagerLockThreadsInfo lockThreadsInfo = null;
        Map<Long, RuntimeManagerLockThreadsInfo> map = this.engineLocks;
        synchronized (map) {
            lockThreadsInfo = this.engineLocks.computeIfAbsent(id, key -> new RuntimeManagerLockThreadsInfo(this.runtimeManagerLockFactory.newRuntimeManagerLock()));
            lockThreadsInfo.set();
        }
        logger.debug("Trying to get a lock {} for {} by {}", new Object[]{lockThreadsInfo, id, runtime});
        try {
            this.lock(lockThreadsInfo.getRuntimeManagerLock());
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted lock {}", (Object)lockThreadsInfo.getRuntimeManagerLock());
            throw e;
        }
        logger.debug("Lock {} taken for {} by {} for waiting threads by {}", new Object[]{lockThreadsInfo, id, runtime, lockThreadsInfo.count()});
    }

    protected abstract void lock(RuntimeManagerLock var1) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Long id, RuntimeEngine runtime) {
        RuntimeManagerLockThreadsInfo lockThreadsInfo = null;
        Map<Long, RuntimeManagerLockThreadsInfo> map = this.engineLocks;
        synchronized (map) {
            lockThreadsInfo = this.engineLocks.get(id);
            if (lockThreadsInfo == null) {
                logger.warn("[LOCK] lock {} is already removed for {} unlocked by {}", new Object[]{id, lockThreadsInfo, runtime});
                return;
            }
            lockThreadsInfo.unset();
            if (lockThreadsInfo.count() == 0) {
                logger.debug("[LOCK] Removing lock for {} for lock  {} from list as non is waiting for it by {}", new Object[]{id, lockThreadsInfo, runtime});
                this.engineLocks.remove(id);
            }
        }
        if (lockThreadsInfo.isHeldByCurrentThread()) {
            this.unlock(lockThreadsInfo.getRuntimeManagerLock());
            logger.debug("[LOCK] process instance id {} with thread info {} unlocked by {}", new Object[]{id, lockThreadsInfo, runtime});
        } else {
            logger.warn("[LOCK] trying to unlock for {} for lock {} no lock held by {}", new Object[]{id, lockThreadsInfo, runtime});
        }
    }

    protected abstract void unlock(RuntimeManagerLock var1);
}

