/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;

public class DebugRuntimeManagerLock
implements RuntimeManagerLock {
    private ReentrantLock lock = new ReentrantLock(true);
    private List<StackTraceElement[]> traces = new ArrayList<StackTraceElement[]>();
    private long currentThreadId = -1L;

    @Override
    public void lock() {
        this.lock.lock();
        this.addTraces();
    }

    @Override
    public boolean tryLock(long units, TimeUnit timeUnit) throws InterruptedException {
        boolean outcome = this.lock.tryLock(units, timeUnit);
        if (outcome) {
            this.addTraces();
        }
        return outcome;
    }

    @Override
    public void lockInterruptible() throws InterruptedException {
        this.lock.lockInterruptibly();
        this.addTraces();
    }

    private void addTraces() {
        long newThreadId = Thread.currentThread().getId();
        if (this.currentThreadId < 0L || this.currentThreadId != newThreadId) {
            this.currentThreadId = newThreadId;
            this.traces.clear();
        }
        this.traces.add(Thread.currentThread().getStackTrace());
    }

    @Override
    public void unlock() {
        if (this.currentThreadId == Thread.currentThread().getId() && this.lock.getHoldCount() == 1) {
            this.traces.clear();
        }
        this.lock.unlock();
    }

    @Override
    public ReentrantLock internalLock() {
        return this.lock;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DebugRuntimeManagerLock [");
        builder.append(this.lock);
        builder.append("]\n");
        builder.append("--------CURRENT REENTRANT STACKTRACE-----------------------\n");
        for (int i = 0; i < this.traces.size(); ++i) {
            builder.append("\tSTACKTRACE " + i + "\n");
            StackTraceElement[] trace = this.traces.get(i);
            for (int j = 0; j < trace.length; ++j) {
                builder.append("\t\t\t" + trace[j] + "\n");
            }
        }
        builder.append("--------END CURRENT REENTRANT STACKTRACE-------------------\n");
        return builder.toString();
    }
}

