/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jbpm.runtime.manager.impl.lock.DefaultRuntimeManagerLockFactory;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockFactory;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyRuntimeManagerLockStrategy
implements RuntimeManagerLockStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LegacyRuntimeManagerLockStrategy.class);
    protected ConcurrentMap<Long, RuntimeManagerLock> engineLocks = new ConcurrentHashMap<Long, RuntimeManagerLock>();
    private RuntimeManagerLockFactory runtimeManagerLockFactory = new DefaultRuntimeManagerLockFactory();

    @Override
    public void init(RuntimeManagerLockFactory factory) {
        this.runtimeManagerLockFactory = factory;
    }

    @Override
    public void lock(Long id, RuntimeEngine runtime) {
        RuntimeManagerLock newLock = this.runtimeManagerLockFactory.newRuntimeManagerLock();
        RuntimeManagerLock lock = this.engineLocks.putIfAbsent(id, newLock);
        if (lock == null) {
            lock = newLock;
            logger.debug("New lock created as it did not exist before");
        } else {
            logger.debug("Lock exists with {} waiting threads", (Object)lock.internalLock().getQueueLength());
        }
        logger.debug("Trying to get a lock {} for {} by {}", new Object[]{lock, id, runtime});
        lock.lock();
        logger.debug("Lock {} taken for {} by {} for waiting threads by {}", new Object[]{lock, id, runtime, lock.internalLock().hasQueuedThreads()});
    }

    @Override
    public void unlock(Long id, RuntimeEngine runtime) {
        RuntimeManagerLock lock = (RuntimeManagerLock)this.engineLocks.get(id);
        if (lock != null) {
            if (!lock.internalLock().hasQueuedThreads()) {
                logger.debug("Removing lock {} from list as non is waiting for it by {}", (Object)lock, (Object)runtime);
                this.engineLocks.remove(id);
            }
            if (lock.internalLock().isHeldByCurrentThread()) {
                lock.unlock();
                logger.debug("{} unlocked by {}", (Object)lock, (Object)runtime);
            }
        }
    }
}

