/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.HashSet;
import java.util.Set;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;

class RuntimeManagerLockThreadsInfo {
    private Set<Long> threadIds = new HashSet<Long>();
    private RuntimeManagerLock runtimeManagerLock;

    public RuntimeManagerLockThreadsInfo(RuntimeManagerLock runtimeManagerLock) {
        this.runtimeManagerLock = runtimeManagerLock;
    }

    public void set() {
        this.threadIds.add(Thread.currentThread().getId());
    }

    public void unset() {
        this.threadIds.remove(Thread.currentThread().getId());
    }

    public int count() {
        return this.threadIds.size();
    }

    public void lock() {
        this.runtimeManagerLock.lock();
    }

    public void unlock() {
        this.runtimeManagerLock.unlock();
    }

    public boolean hasQueuedThreads() {
        return this.runtimeManagerLock.internalLock().hasQueuedThreads();
    }

    public boolean isHeldByCurrentThread() {
        return this.runtimeManagerLock.internalLock().isHeldByCurrentThread();
    }

    public RuntimeManagerLock getRuntimeManagerLock() {
        return this.runtimeManagerLock;
    }
}

