/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl.quartz;

import java.util.ArrayList;
import java.util.List;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;

public class QuartzUtils
implements StdJDBCConstants {
    String SELECT_NEXT_TRIGGER_TO_ACQUIRE = "SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME < ? AND (NEXT_FIRE_TIME >= ?) ";
    String ORDER_BY = "ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC";
    String COUNT_MISFIRED_TRIGGERS_IN_STATES = "SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND ((TRIGGER_STATE = ?) OR (TRIGGER_STATE = ?)) ";
    String SELECT_MISFIRED_TRIGGERS_IN_STATES = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND ((TRIGGER_STATE = ?) OR (TRIGGER_STATE = ?)) ";
    String MISFIRED_ORDER_BY = "ORDER BY NEXT_FIRE_TIME ASC";

    public List<String> getDeployments() {
        ArrayList<String> deploymentIds = new ArrayList<String>(RuntimeManagerRegistry.get().getRegisteredIdentifiers());
        deploymentIds.add("jbpm");
        return deploymentIds;
    }

    public String nextTriggerQuery(List<String> deploymentIds) {
        String query = this.SELECT_NEXT_TRIGGER_TO_ACQUIRE + this.buildGroupFilter(deploymentIds) + this.ORDER_BY;
        return query;
    }

    public String countMisfiredTriggersQuery(List<String> deploymentIds) {
        String query = this.COUNT_MISFIRED_TRIGGERS_IN_STATES + this.buildGroupFilter(deploymentIds);
        return query;
    }

    public String misfiredTriggersQuery(List<String> deploymentIds) {
        String query = this.SELECT_MISFIRED_TRIGGERS_IN_STATES + this.buildGroupFilter(deploymentIds) + this.MISFIRED_ORDER_BY;
        return query;
    }

    protected String buildGroupFilter(List<String> deploymentIds) {
        StringBuilder filter = new StringBuilder(" (");
        deploymentIds.forEach(s -> filter.append("?,"));
        filter.deleteCharAt(filter.length() - 1);
        filter.append(") ");
        String groupFilter = "AND TRIGGER_GROUP IN " + filter;
        return groupFilter;
    }
}

