/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.document.Document;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="document-object")
public class DocumentImpl
implements Document {
    private static final long serialVersionUID = -7422666286189013484L;
    private String identifier = "";
    private String name;
    private String link = "";
    private long size;
    private Date lastModified;
    private byte[] content;
    private Map<String, String> attributes;

    public DocumentImpl() {
        this.identifier = UUID.randomUUID().toString();
    }

    public DocumentImpl(String identifier, String name, long size, Date lastModified) {
        this.identifier = identifier;
        this.name = name;
        this.size = size;
        this.lastModified = lastModified;
        this.attributes = new HashMap<String, String>();
    }

    public DocumentImpl(String name, long size, Date lastModified) {
        this();
        this.name = name;
        this.size = size;
        this.lastModified = lastModified;
        this.attributes = new HashMap<String, String>();
    }

    public DocumentImpl(String identifier, String name, long size, Date lastModified, String link) {
        this.identifier = identifier;
        this.name = name;
        this.size = size;
        this.lastModified = lastModified;
        this.link = link;
        this.attributes = new HashMap<String, String>();
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public void addAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return this.name + "####" + this.size + "####" + (this.lastModified != null ? sdf.format(this.lastModified) : "") + "####" + this.identifier;
    }
}

