/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.event.ExecutorEventSupport;
import org.jbpm.executor.impl.jpa.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.jpa.JPAExecutorStoreService;
import org.jbpm.executor.impl.mem.InMemoryExecutorAdminServiceImpl;
import org.jbpm.executor.impl.mem.InMemoryExecutorQueryServiceImpl;
import org.jbpm.executor.impl.mem.InMemoryExecutorStoreService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceFactory {
    private static final String mode = System.getProperty("org.jbpm.cdi.executor.mode", "singleton");
    private static final String availableJobsExecutorName = System.getProperty("org.jbpm.cdi.executor.jndi", "java:module/AvailableJobsExecutor");
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServiceFactory.class);
    private static ExecutorService serviceInstance;

    public static synchronized ExecutorService newExecutorService(EntityManagerFactory emf) {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure(emf);
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure(emf);
    }

    public static synchronized ExecutorService newExecutorService() {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure();
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure();
    }

    public static synchronized void resetExecutorService(ExecutorService executorService) {
        if (executorService.equals(serviceInstance)) {
            serviceInstance = null;
        }
    }

    private static ExecutorService configure(EntityManagerFactory emf) {
        ExecutorEventSupport eventSupport = new ExecutorEventSupport();
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        ExecutorImpl executor = new ExecutorImpl();
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        storeService.setCommandService((CommandExecutor)commandService);
        storeService.setEmf(emf);
        storeService.setEventSupport(eventSupport);
        executor.setExecutorStoreService(storeService);
        executor.setEventSupport(eventSupport);
        queryService.setCommandService((CommandExecutor)commandService);
        adminService.setCommandService((CommandExecutor)commandService);
        ExecutorServiceImpl service = new ExecutorServiceImpl((Executor)executor);
        service.setQueryService((ExecutorQueryService)queryService);
        service.setExecutor((Executor)executor);
        service.setAdminService(adminService);
        service.setEventSupport(eventSupport);
        return service;
    }

    private static ExecutorService configure() {
        ExecutorEventSupport eventSupport = new ExecutorEventSupport();
        InMemoryExecutorQueryServiceImpl queryService = new InMemoryExecutorQueryServiceImpl(true);
        ExecutorImpl executor = new ExecutorImpl();
        InMemoryExecutorAdminServiceImpl adminService = new InMemoryExecutorAdminServiceImpl(true);
        InMemoryExecutorStoreService storeService = new InMemoryExecutorStoreService(true);
        storeService.setEventSupport(eventSupport);
        executor.setExecutorStoreService(storeService);
        executor.setEventSupport(eventSupport);
        queryService.setStoreService(storeService);
        adminService.setStoreService(storeService);
        ExecutorServiceImpl service = new ExecutorServiceImpl((Executor)executor);
        service.setQueryService((ExecutorQueryService)queryService);
        service.setExecutor((Executor)executor);
        service.setAdminService(adminService);
        service.setEventSupport(eventSupport);
        return service;
    }

    public static ExecutorRunnable buildRunable(EntityManagerFactory emf, ExecutorEventSupport eventSupport) {
        ExecutorRunnable runnable = new ExecutorRunnable();
        AvailableJobsExecutor jobExecutor = null;
        try {
            jobExecutor = (AvailableJobsExecutor)InitialContext.doLookup(availableJobsExecutorName);
        }
        catch (Exception e) {
            jobExecutor = ExecutorServiceFactory.buildJobExecutor(emf, eventSupport);
        }
        runnable.setAvailableJobsExecutor(jobExecutor);
        return runnable;
    }

    private static AvailableJobsExecutor buildJobExecutor(EntityManagerFactory emf, ExecutorEventSupport eventSupport) {
        AvailableJobsExecutor jobExecutor = new AvailableJobsExecutor();
        ClassCacheManager classCacheManager = new ClassCacheManager();
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        TransactionalCommandService cmdService = new TransactionalCommandService(emf);
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        storeService.setCommandService((CommandExecutor)cmdService);
        storeService.setEmf(emf);
        queryService.setCommandService((CommandExecutor)cmdService);
        jobExecutor.setClassCacheManager(classCacheManager);
        jobExecutor.setQueryService((ExecutorQueryService)queryService);
        jobExecutor.setExecutorStoreService(storeService);
        jobExecutor.setEventSupport(eventSupport);
        try {
            Object beanManager = InitialContext.doLookup("java:comp/BeanManager");
            jobExecutor.addContextData("BeanManager", beanManager);
        }
        catch (NamingException ex) {
            logger.debug("CDI beans cannot be used in executor commands, because no CDI manager has been found in JNDI.");
        }
        return jobExecutor;
    }

    public static ExecutorRunnable buildRunable(ExecutorEventSupport eventSupport) {
        ExecutorRunnable runnable = new ExecutorRunnable();
        AvailableJobsExecutor jobExecutor = null;
        try {
            jobExecutor = (AvailableJobsExecutor)InitialContext.doLookup(availableJobsExecutorName);
        }
        catch (Exception e) {
            jobExecutor = new AvailableJobsExecutor();
            ClassCacheManager classCacheManager = new ClassCacheManager();
            InMemoryExecutorStoreService storeService = new InMemoryExecutorStoreService(true);
            InMemoryExecutorQueryServiceImpl queryService = new InMemoryExecutorQueryServiceImpl(true);
            queryService.setStoreService(storeService);
            jobExecutor.setClassCacheManager(classCacheManager);
            jobExecutor.setQueryService((ExecutorQueryService)queryService);
            jobExecutor.setExecutorStoreService(storeService);
            jobExecutor.setEventSupport(eventSupport);
            try {
                Object beanManager = InitialContext.doLookup("java:comp/BeanManager");
                jobExecutor.addContextData("BeanManager", beanManager);
            }
            catch (NamingException ex) {
                logger.debug("CDI beans cannot be used in executor commands, because no CDI manager has been found in JNDI.");
            }
        }
        runnable.setAvailableJobsExecutor(jobExecutor);
        return runnable;
    }
}

