/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.context.variable.VariableViolationException;
import org.jbpm.process.instance.ProcessInstance;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.identity.IdentityProvider;

public class RemoveDataCaseFileInstanceCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335953L;
    private List<String> variableNames;
    private AuthorizationManager authorizationManager;
    private Long processInstanceId;

    public RemoveDataCaseFileInstanceCommand(Long processInstanceId, IdentityProvider identityProvider, List<String> variableNames, AuthorizationManager authorizationManager) {
        super(identityProvider);
        this.processInstanceId = processInstanceId;
        this.variableNames = variableNames;
        this.authorizationManager = authorizationManager;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        this.authorizationManager.checkDataAuthorization(caseFile.getCaseId(), caseFile, this.variableNames);
        ProcessInstance pi = (ProcessInstance)ksession.getProcessInstance(this.processInstanceId.longValue());
        VariableScope variableScope = (VariableScope)pi.getContextContainer().getDefaultContext("VariableScope");
        for (String name : this.variableNames) {
            if (caseFile.getData(name) == null || !variableScope.isReadOnly("caseFile_" + name)) continue;
            throw new VariableViolationException(Long.valueOf(pi.getId()), name, "Variable '" + name + "' is already set and is marked as read only");
        }
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        HashMap<String, Object> remove = new HashMap<String, Object>();
        this.variableNames.forEach(p -> remove.put((String)p, caseFile.getData(p)));
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseDataRemoved(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), remove);
        this.variableNames.forEach(p -> caseFile.remove(p));
        ksession.update(factHandle, (Object)caseFile);
        this.triggerRules(ksession);
        caseEventSupport.fireAfterCaseDataRemoved(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), remove);
        return null;
    }
}

