/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeType;

public class DynamicNode
extends CompositeContextNode {
    private static final long serialVersionUID = 510L;
    private String activationExpression;
    private String completionExpression;
    private String language;

    public DynamicNode() {
        super(NodeType.AD_HOC_SUBPROCESS);
    }

    @Override
    public boolean acceptsEvent(String type, Object event, Function<String, String> resolver) {
        if (type.equals(this.getActivationEventName())) {
            return true;
        }
        for (Node node : this.getNodes()) {
            if (node.getName() == null || !resolver.apply(node.getName()).contains(type) || !node.getIncomingConnections().isEmpty()) continue;
            return true;
        }
        return super.acceptsEvent(type, event);
    }

    @Override
    public boolean acceptsEvent(String type, Object event) {
        if (type.equals(this.getActivationEventName())) {
            return true;
        }
        for (Node node : this.getNodes()) {
            if (!type.equals(node.getName()) || !node.getIncomingConnections().isEmpty()) continue;
            return true;
        }
        return super.acceptsEvent(type, event);
    }

    @Override
    public Node internalGetNode(long id) {
        try {
            return this.getNode(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCompletionExpression() {
        return this.completionExpression;
    }

    public void setCompletionExpression(String expression) {
        this.completionExpression = expression;
    }

    public String getActivationExpression() {
        return this.activationExpression;
    }

    public void setActivationExpression(String activationExpression) {
        this.activationExpression = activationExpression;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Node> getAutoStartNodes() {
        List<Node> nodes = Arrays.stream(this.getNodes()).filter(n -> n.getIncomingConnections().isEmpty() && "true".equalsIgnoreCase((String)n.getMetaData().get("customAutoStart"))).collect(Collectors.toList());
        return nodes;
    }

    public String getActivationEventName() {
        if (this.activationExpression == null || this.activationExpression.isEmpty()) {
            return null;
        }
        String activationSignalName = "RuleFlow-AdHocActivate-" + ((WorkflowProcess)this.getNodeContainer()).getId() + "-" + this.getUniqueId();
        return activationSignalName;
    }
}

