/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DataAssociationFactory {
    protected static final String LANG_EXPRESSION_ATTR = "language";
    protected static final String DEFAULT_DIALECT = "XPath";
    protected static final String USE_DEFINITION_LANGUAGE_PROPERTY = "org.kie.jbpm.bpmn2.useDefinitionLanguage";
    private static final String SOURCE_REF = "sourceRef";
    private static final String TARGET_REF = "targetRef";
    private static final String TRANSFORMATION = "transformation";
    private static final String ASSIGNMENT = "assignment";
    private static final Logger logger = LoggerFactory.getLogger(DataAssociationFactory.class);
    private static Map<String, Pattern> dialectPatterns = DataAssociationFactory.buildDialectPatterns(ProcessDialectRegistry.getDialects());

    private DataAssociationFactory() {
    }

    public static DataAssociation readDataOutputAssociation(Node xmlNode, Map<String, String> dataOutputs) {
        NodeList nodeList = xmlNode.getChildNodes();
        String source = null;
        String target = null;
        Transformation transformation = null;
        ArrayList<Assignment> assignment = new ArrayList<Assignment>();
        block12: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            switch (subNode.getNodeName()) {
                case "sourceRef": {
                    source = subNode.getTextContent();
                    String mapped = dataOutputs.get(source);
                    if (mapped == null) {
                        logger.warn("Data outputs in this node {} does not contain source {}", (Object)xmlNode.getAttributes().getNamedItem("id"), (Object)source);
                        continue block12;
                    }
                    source = mapped;
                    continue block12;
                }
                case "targetRef": {
                    target = subNode.getTextContent();
                    continue block12;
                }
                case "transformation": {
                    String lang = subNode.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR).getNodeValue();
                    String expression = subNode.getTextContent();
                    transformation = new Transformation(lang, expression, source);
                    continue block12;
                }
                case "assignment": {
                    assignment.add(DataAssociationFactory.readAssignment(subNode, dataOutputs));
                }
            }
        }
        return new DataAssociation(source, target, assignment, transformation);
    }

    public static void readDataInputAssociation(Node xmlNode, Map<String, String> dataInputs, BiPredicate<String, List<Assignment>> isLegacy, Consumer<DataAssociation> addAssignment, BiConsumer<String, Object> legacyAssignment) {
        NodeList nodeList = xmlNode.getChildNodes();
        String source = null;
        String target = null;
        Transformation transformation = null;
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        Node assignmentNode = null;
        block12: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            switch (subNode.getNodeName()) {
                case "sourceRef": {
                    source = subNode.getTextContent();
                    continue block12;
                }
                case "targetRef": {
                    target = subNode.getTextContent();
                    String mapped = dataInputs.get(target);
                    if (mapped == null) {
                        logger.warn("Data inputs in this node {} does not contain target {}", (Object)xmlNode.getAttributes().getNamedItem("id"), (Object)target);
                        continue block12;
                    }
                    target = mapped;
                    continue block12;
                }
                case "transformation": {
                    transformation = new Transformation(subNode.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR).getNodeValue(), subNode.getTextContent());
                    continue block12;
                }
                case "assignment": {
                    assignmentNode = subNode;
                    assignments.add(DataAssociationFactory.readAssignment(subNode, dataInputs));
                }
            }
        }
        if (isLegacy.test(source, assignments)) {
            Object value = DataAssociationFactory.getValue(assignmentNode);
            if (value != null) {
                legacyAssignment.accept(target, value);
            }
        } else {
            addAssignment.accept(new DataAssociation(source, target, assignments, transformation));
        }
    }

    public static boolean isLegacyAssignment(String source, List<Assignment> assignments) {
        return source == null && assignments.isEmpty() || source == null && !assignments.isEmpty() && assignments.get(0).getDialect().equals(DEFAULT_DIALECT);
    }

    private static Object getValue(Node assignmentNode) {
        Object value = null;
        if (assignmentNode != null) {
            Node fromNode = assignmentNode.getFirstChild();
            NodeList nl = fromNode.getChildNodes();
            if (nl.getLength() > 1) {
                value = fromNode.getNodeValue();
            } else if (nl.getLength() == 1 && (value = nl.item(0)) instanceof Text) {
                String text = ((Text)value).getTextContent();
                value = text.startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text;
            }
        }
        return value;
    }

    public static List<Assignment> readAssignments(Node subNode) {
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            assignments.add(DataAssociationFactory.readAssignment(subNode));
            subNode = subNode.getNextSibling();
        }
        return assignments;
    }

    public static Assignment readAssignment(Node xmlNode) {
        return DataAssociationFactory.readAssignment(xmlNode, Collections.emptyMap());
    }

    public static Assignment readAssignment(Node xmlNode, Map<String, String> mapping) {
        NodeList nodeList = xmlNode.getChildNodes();
        Node from = null;
        Node to = null;
        block8: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            switch (subNode.getNodeName()) {
                case "from": {
                    from = subNode;
                    continue block8;
                }
                case "to": {
                    to = subNode;
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized node name " + subNode.getNodeName() + " in assigment " + xmlNode.getAttributes().getNamedItem("id").getNodeValue());
                }
            }
        }
        if (to == null && from == null) {
            throw new IllegalArgumentException(" Assignment " + xmlNode.getAttributes().getNamedItem("id").getNodeValue() + " should have at least from or to subnode");
        }
        return new Assignment(DataAssociationFactory.getDialect(xmlNode, from, to), DataAssociationFactory.resolveContent(from, mapping), DataAssociationFactory.resolveContent(to, mapping));
    }

    private static String resolveContent(Node node, Map<String, String> mapping) {
        if (node == null) {
            return null;
        }
        String content = node.getTextContent();
        String mapped = mapping.get(content);
        return mapped == null ? content : mapped;
    }

    protected static String getDialect(Node node, Node from, Node to) {
        Collection dialects = ProcessDialectRegistry.getDialects();
        if (!dialects.equals(dialectPatterns.keySet())) {
            dialectPatterns = DataAssociationFactory.buildDialectPatterns(dialects);
        }
        String dialect = null;
        if (from != null) {
            dialect = DataAssociationFactory.findDialect(from.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR));
        }
        if (dialect == null && to != null) {
            dialect = DataAssociationFactory.findDialect(to.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR));
        }
        if (dialect == null && Boolean.getBoolean(USE_DEFINITION_LANGUAGE_PROPERTY)) {
            Node parentNode;
            for (parentNode = node.getParentNode(); parentNode != null && !parentNode.getLocalName().equals("Definitions"); parentNode = parentNode.getParentNode()) {
            }
            if (parentNode != null) {
                dialect = DataAssociationFactory.findDialect(parentNode.getAttributes().getNamedItem("expressionLanguage"));
            }
        }
        if (dialect == null && (from != null && PatternConstants.PARAMETER_MATCHER.matcher(from.getTextContent()).matches() || to != null && PatternConstants.PARAMETER_MATCHER.matcher(to.getTextContent()).matches())) {
            dialect = "mvel";
        }
        return dialect == null ? DEFAULT_DIALECT : dialect;
    }

    private static String findDialect(Node languageAttr) {
        if (languageAttr != null) {
            for (Map.Entry<String, Pattern> dialect : dialectPatterns.entrySet()) {
                if (!dialect.getValue().matcher(languageAttr.getNodeValue()).find()) continue;
                return dialect.getKey();
            }
        }
        return null;
    }

    private static Map<String, Pattern> buildDialectPatterns(Collection<String> dialects) {
        return dialects.stream().collect(Collectors.toMap(x -> x, dialect -> Pattern.compile("\\b" + dialect + "\\b", 2)));
    }
}

