/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.exceptions;

import java.util.HashMap;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.examples.exceptions.service.ExceptionService;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;

public class ExceptionHandlingSignalExample {
    public static final void main(String[] args) {
        ExceptionHandlingSignalExample.runExample();
    }

    public static void runExample() {
        RuntimeManager manager = ExceptionHandlingSignalExample.createManager();
        KieSession ksession = manager.getRuntimeEngine(null).getKieSession();
        String eventType = "exception-signal";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", signallingTaskWrapper);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serviceInputItem", "Input to Original Service");
        ksession.startProcess("ProcessWithExceptionHandlingSignal", params);
        manager.close();
    }

    private static RuntimeManager createManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addAsset(KieServices.Factory.get().getResources().newClassPathResource("exceptions/ExceptionHandlingWithSignal.bpmn2"), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }
}

