/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts.util;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.TestPersistenceContextBase;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.jbpm.test.util.DatabaseScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestsUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestsUtil.class);

    public static File[] getDDLScriptFilesByDatabaseType(File folderWithDDLs, DatabaseType databaseType, ScriptFilter scriptFilter) {
        File folderWithScripts = new File(folderWithDDLs.getPath() + File.separator + databaseType.getScriptsFolderName());
        if (!folderWithScripts.exists()) {
            logger.warn("Folder with DDLs doesn't exist {}", (Object)folderWithDDLs);
            return new File[0];
        }
        File[] foundFiles = (File[])Arrays.asList(folderWithScripts.listFiles()).stream().filter(scriptFilter.build()).toArray(File[]::new);
        foundFiles = (File[])Arrays.stream(foundFiles).map(DatabaseScript::new).sorted().map(DatabaseScript::getScript).toArray(File[]::new);
        if (databaseType.equals((Object)DatabaseType.POSTGRESQL)) {
            Arrays.sort(foundFiles, Comparator.comparing(s -> s.getName().contains("schema")).reversed());
        }
        logger.info("Returned DDL files: {}", Arrays.stream(foundFiles).map(File::getName).collect(Collectors.toList()));
        return foundFiles;
    }

    public static DatabaseType getDatabaseType(Properties dataSourceProperties) {
        String hibernateDialect = dataSourceProperties.getProperty("dialect");
        if (!"".equals(hibernateDialect)) {
            return TestsUtil.getDatabaseTypeBySQLDialect(hibernateDialect);
        }
        return DatabaseType.H2;
    }

    public static DatabaseType getDatabaseTypeBySQLDialect(String sqlDialect) {
        if (sqlDialect.contains("DB2Dialect")) {
            return DatabaseType.DB2;
        }
        if (sqlDialect.contains("DerbyDialect")) {
            return DatabaseType.DERBY;
        }
        if (sqlDialect.contains("H2Dialect")) {
            return DatabaseType.H2;
        }
        if (sqlDialect.contains("HSQLDialect")) {
            return DatabaseType.HSQLDB;
        }
        if (sqlDialect.contains("MySQL5Dialect")) {
            return DatabaseType.MYSQL5;
        }
        if (sqlDialect.contains("MySQL5InnoDBDialect")) {
            return DatabaseType.MYSQLINNODB;
        }
        if (sqlDialect.contains("Oracle")) {
            return DatabaseType.ORACLE;
        }
        if (sqlDialect.contains("Postgre")) {
            return DatabaseType.POSTGRESQL;
        }
        if (sqlDialect.contains("SQLServer2008Dialect") || sqlDialect.contains("SQLServer2012Dialect")) {
            return DatabaseType.SQLSERVER2008;
        }
        if (sqlDialect.contains("SQLServerDialect") || sqlDialect.contains("SQLServer2005Dialect")) {
            return DatabaseType.SQLSERVER;
        }
        if (sqlDialect.contains("SybaseASE157Dialect")) {
            return DatabaseType.SYBASE;
        }
        throw new IllegalArgumentException("SQL dialect type " + sqlDialect + " is not supported!");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static void clearSchema() {
        TestPersistenceContextBase clearSchemaContext = new TestPersistenceContextBase();
        clearSchemaContext.init(PersistenceUnit.CLEAR_SCHEMA);
        clearSchemaContext.clean();
    }

    private TestsUtil() {
    }
}

