/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.request;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jbpm.examples.request.UIWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;

public class UIWorkItemHandlerDialog
extends JDialog {
    private static final long serialVersionUID = 510L;
    private Map<String, Object> results = new HashMap<String, Object>();
    private UIWorkItemHandler handler;
    private WorkItem workItem;
    private JTextField resultNameTextField;
    private JTextField resultValueTextField;
    private JButton addResultButton;
    private JButton completeButton;
    private JButton abortButton;

    public UIWorkItemHandlerDialog(UIWorkItemHandler handler, WorkItem workItem) {
        super(handler, "Execute Work Item", true);
        this.handler = handler;
        this.workItem = workItem;
        this.setSize(new Dimension(400, 300));
        this.initializeComponent();
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JTextArea params = new JTextArea();
        params.setText(this.getParameters());
        params.setEditable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 5;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)params, c);
        JLabel resultName = new JLabel("Result");
        c = new GridBagConstraints();
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)resultName, c);
        this.resultNameTextField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.3;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.resultNameTextField, c);
        JLabel resultValue = new JLabel("Value");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)resultValue, c);
        this.resultValueTextField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 0.7;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.resultValueTextField, c);
        this.addResultButton = new JButton("Add");
        this.addResultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UIWorkItemHandlerDialog.this.addResult();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.addResultButton, c);
        this.completeButton = new JButton("Complete");
        this.completeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UIWorkItemHandlerDialog.this.complete();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.completeButton, c);
        this.abortButton = new JButton("Abort");
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UIWorkItemHandlerDialog.this.abort();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.abortButton, c);
    }

    private String getParameters() {
        String result = "";
        if (this.workItem.getParameters() != null) {
            for (Map.Entry<String, Object> entry : this.workItem.getParameters().entrySet()) {
                result = result + entry.getKey() + " = " + entry.getValue() + "\n";
            }
        }
        return result;
    }

    private void addResult() {
        this.results.put(this.resultNameTextField.getText(), this.resultValueTextField.getText());
        this.resultNameTextField.setText("");
        this.resultValueTextField.setText("");
    }

    private void complete() {
        this.handler.complete(this.workItem, this.results);
        this.dispose();
    }

    private void abort() {
        this.handler.abort(this.workItem);
        this.dispose();
    }
}

