/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.Resettable;

public class VersionInspector
extends AbstractVisitor
implements Resettable {
    private Version minimum = Version.getMinimum();
    private Version maximum = Version.getMaximum();
    private static Map<String, Version> functionVersions = new LinkedHashMap<String, Version>();

    @Override
    public void reset() {
        this.minimum = Version.getMinimum();
        this.maximum = Version.getMaximum();
    }

    @Override
    public VisitorAction visit(PMMLObject object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            this.inspect(clazz);
        }
        List<Field> fields = ReflectionUtil.getFields(object.getClass());
        for (Field field : fields) {
            Field enumField;
            Object value = ReflectionUtil.getFieldValue(field, object);
            this.inspect(field, value);
            if (!(value instanceof Enum)) continue;
            Enum enumValue = (Enum)value;
            try {
                Class<?> enumClazz = enumValue.getClass();
                enumField = enumClazz.getField(enumValue.name());
            }
            catch (NoSuchFieldException nsfe) {
                throw new RuntimeException(nsfe);
            }
            this.inspect(enumField);
        }
        return super.visit(object);
    }

    @Override
    public VisitorAction visit(Apply apply) {
        String function = apply.getFunction();
        Version version = functionVersions.get(function);
        if (version != null) {
            this.updateMinimum(version);
        }
        return super.visit(apply);
    }

    private void inspect(Field field, Object value) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (ReflectionUtil.isDefaultValue(value)) {
                return;
            }
        } else if (VersionInspector.isNull(value)) {
            Required required;
            Optional optional = field.getAnnotation(Optional.class);
            if (optional != null) {
                this.updateMinimum(optional.value());
            }
            if ((required = field.getAnnotation(Required.class)) != null) {
                this.updateMaximum(VersionInspector.previous(required.value()));
            }
            return;
        }
        this.inspect(field);
    }

    private void inspect(AnnotatedElement element) {
        Removed removed;
        Added added = element.getAnnotation(Added.class);
        if (added != null) {
            this.updateMinimum(added.value());
        }
        if ((removed = element.getAnnotation(Removed.class)) != null) {
            this.updateMaximum(removed.value());
        }
    }

    public Version getMinimum() {
        return this.minimum;
    }

    private void updateMinimum(Version minimum) {
        if (minimum != null && minimum.compareTo(this.minimum) > 0) {
            this.minimum = minimum;
        }
    }

    public Version getMaximum() {
        return this.maximum;
    }

    private void updateMaximum(Version maximum) {
        if (maximum != null && maximum.compareTo(this.maximum) < 0) {
            this.maximum = maximum;
        }
    }

    private static boolean isNull(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return value == null;
    }

    private static Version previous(Version version) {
        Version[] values = Version.values();
        return values[version.ordinal() - 1];
    }

    private static void declareFunctions(Version version, String ... functions) {
        for (String function : functions) {
            functionVersions.put(function, version);
        }
    }

    static {
        VersionInspector.declareFunctions(Version.PMML_3_0, "+", "-", "*", "/", "min", "max", "sum", "avg", "log10", "ln", "sqrt", "abs", "uppercase", "substring", "trimBlanks", "formatNumber", "formatDatetime", "dateDaysSinceYear", "dateSecondsSinceYear", "dateSecondsSinceMidnight");
        VersionInspector.declareFunctions(Version.PMML_3_1, "exp", "pow", "threshold", "floor", "ceil", "round");
        VersionInspector.declareFunctions(Version.PMML_4_0, "isMissing", "isNotMissing", "equal", "notEqual", "lessThan", "lessOrEqual", "greaterThan", "greaterOrEqual", "and", "or", "not", "isIn", "isNotIn", "if");
        VersionInspector.declareFunctions(Version.PMML_4_1, "median", "product", "lowercase");
        VersionInspector.declareFunctions(Version.PMML_4_2, "concat", "replace", "matches");
        VersionInspector.declareFunctions(Version.PMML_4_3, "normalCDF", "normalPDF", "stdNormalCDF", "stdNormalPDF", "erf", "normalIDF", "stdNormalIDF");
        VersionInspector.declareFunctions(Version.PMML_4_4, "modulo", "isValid", "isNotValid", "expm1", "hypot", "ln1p", "rint", "sin", "asin", "sinh", "cos", "acos", "cosh", "tan", "atan", "tanh");
        VersionInspector.declareFunctions(Version.XPMML, "x-atan2");
    }
}

