/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.CorrelationKeyCommand;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.jaxb.CorrelationKeyXmlAdapter;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;

@XmlAccessorType(value=XmlAccessType.NONE)
public class CreateCorrelatedProcessInstanceCommand
implements ExecutableCommand<ProcessInstance>,
IdentifiableResult,
CorrelationKeyCommand {
    private static final long serialVersionUID = -7810538827527530319L;
    @XmlAttribute(required=true)
    private String processId;
    @XmlElement(name="correlation-key", required=true)
    @XmlJavaTypeAdapter(value=CorrelationKeyXmlAdapter.class)
    private CorrelationKey correlationKey;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @XmlElementWrapper(name="data")
    private List<Object> data = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public CreateCorrelatedProcessInstanceCommand() {
    }

    public CreateCorrelatedProcessInstanceCommand(String processId, CorrelationKey correlationKey) {
        this.processId = processId;
        this.correlationKey = correlationKey;
    }

    public CreateCorrelatedProcessInstanceCommand(String processId, CorrelationKey correlationKey, String outIdentifier) {
        this(processId, correlationKey);
        this.outIdentifier = outIdentifier;
    }

    public CreateCorrelatedProcessInstanceCommand(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        this(processId, correlationKey);
        this.parameters = parameters;
    }

    public CreateCorrelatedProcessInstanceCommand(String processId, CorrelationKey correlationKey, Map<String, Object> parameters, String outIdentifier) {
        this(processId, correlationKey, outIdentifier);
        this.parameters = parameters;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap<String, Object>();
    }

    public void putParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public CorrelationKey getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(CorrelationKey correlationKey) {
        this.correlationKey = correlationKey;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        if (this.data != null) {
            for (Object o : this.data) {
                ksession.insert(o);
            }
        }
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).createProcessInstance(this.processId, this.correlationKey, this.parameters);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, processInstance.getId());
        }
        return processInstance;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("session.createProcessInstance(");
        result.append(this.processId);
        result.append(", ");
        result.append(this.correlationKey);
        result.append(", [");
        if (this.parameters != null) {
            int i = 0;
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                if (i++ > 0) {
                    result.append(", ");
                }
                result.append(entry.getKey());
                result.append("=");
                result.append(entry.getValue());
            }
        }
        result.append("]);");
        return result.toString();
    }
}

