/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.executor.commands.error.AutoAckErrorCommand;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.kie.api.task.model.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAutoAckErrorCommand
extends AutoAckErrorCommand {
    private static final Logger logger = LoggerFactory.getLogger(TaskAutoAckErrorCommand.class);
    private static final String RULE = "Tasks that previously failed but now are in one of the statuses - completed, failed, exited, obsolete, error";

    @Override
    protected List<ExecutionErrorInfo> findErrorsToAck(EntityManager em) {
        List<Object> errorsToAck = new ArrayList<ExecutionErrorInfo>();
        TransactionManager txm = TransactionManagerFactory.get().newTransactionManager();
        boolean txOwner = txm.begin();
        try {
            String findTaskErrorsQuery = "select error from ExecutionErrorInfo error where error.type = :type and error.acknowledged =:acknowledged and error.activityId in (select at.taskId from AuditTaskImpl at where status in (:status))";
            errorsToAck = em.createQuery(findTaskErrorsQuery, ExecutionErrorInfo.class).setParameter("type", (Object)"Task").setParameter("acknowledged", (Object)new Short("0")).setParameter("status", Arrays.asList(Status.Completed.toString(), Status.Exited.toString(), Status.Failed.toString(), Status.Obsolete.toString(), Status.Error.toString())).getResultList();
            txm.commit(txOwner);
        }
        catch (Exception e) {
            logger.error("Execution error in command TaskAutoAckErrorCommand", (Throwable)e);
            txm.rollback(txOwner);
        }
        return errorsToAck;
    }

    @Override
    protected String getAckRule() {
        return RULE;
    }
}

