/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerNIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class ExpCalculator
extends SeriesCalculator {
    public static final ExpCalculator INSTANCE = new ExpCalculator();
    private int n = 0;
    private BigRational oneOverFactorialOfN = BigRational.ONE;

    private ExpCalculator() {
    }

    @Override
    protected BigRational getCurrentFactor() {
        return this.oneOverFactorialOfN;
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.oneOverFactorialOfN = this.oneOverFactorialOfN.divide(this.n);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerNIterator(x, mathContext);
    }
}

