/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManagerLockWatcherSingletonService {
    protected static final Logger logger = LoggerFactory.getLogger(RuntimeManagerLockWatcherSingletonService.class);
    private static final RuntimeManagerLockWatcherSingletonService SERVICE = new RuntimeManagerLockWatcherSingletonService();
    private Long watchLockPolling;
    private Long maxLockProcessingTime;
    private int count = 0;
    private ExecutorService executorService;
    private Queue<LockWatchInfo> locksWatched = new PriorityQueue<LockWatchInfo>();

    private RuntimeManagerLockWatcherSingletonService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryForcedUnlock() {
        Queue<LockWatchInfo> queue = this.locksWatched;
        synchronized (queue) {
            while (!this.locksWatched.isEmpty()) {
                LockWatchInfo info = this.locksWatched.peek();
                long idleTime = info.getCurrentProcessingTime();
                if (this.maxLockProcessingTime > idleTime) {
                    return this.maxLockProcessingTime - idleTime;
                }
                try {
                    long timeExceeded = idleTime - this.maxLockProcessingTime;
                    logger.info("Max process time lock exceeded for process instance id {} by {} ms. Trying forceful release lock {}", new Object[]{info.processInstanceId, timeExceeded, info.lock});
                    info.lock.forceUnlock();
                }
                catch (UnsupportedOperationException e) {
                    logger.warn("Runtime manager lock implementation {} does not allow self release for process instance id {}", (Object)info.lock.getClass().getName(), (Object)info.processInstanceId);
                }
                this.locksWatched.poll();
            }
        }
        return this.watchLockPolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(long processInstanceId, RuntimeManagerLock lock) {
        Queue<LockWatchInfo> queue = this.locksWatched;
        synchronized (queue) {
            this.locksWatched.add(new LockWatchInfo(processInstanceId, lock));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unwatch(long processInstanceId) {
        Queue<LockWatchInfo> queue = this.locksWatched;
        synchronized (queue) {
            this.locksWatched.removeIf(e -> e.getProcessInstanceId() == processInstanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWatched(int processInstanceId) {
        Queue<LockWatchInfo> queue = this.locksWatched;
        synchronized (queue) {
            return this.locksWatched.stream().anyMatch(e -> e.getProcessInstanceId() == (long)processInstanceId);
        }
    }

    private void setWatchLockPolling(Long watchLockPolling) {
        this.watchLockPolling = watchLockPolling;
    }

    private void setMaxLockProcessingTime(Long maxLockProcessingTime) {
        this.maxLockProcessingTime = maxLockProcessingTime;
    }

    private void start() {
        ++this.count;
        if (this.count > 0 && this.watchLockPolling > 0L && this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.submit(new RuntimeManagerLockReaper());
            logger.info("Started watching locks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreference() {
        RuntimeManagerLockWatcherSingletonService runtimeManagerLockWatcherSingletonService = this;
        synchronized (runtimeManagerLockWatcherSingletonService) {
            if (this.executorService != null && --this.count == 0) {
                logger.info("Stopped watching locks");
                this.executorService.shutdownNow();
                this.executorService = null;
            }
        }
    }

    public static RuntimeManagerLockWatcherSingletonService reference() {
        return RuntimeManagerLockWatcherSingletonService.reference(Long.getLong("org.kie.jbpm.lock.polling", 0L), Long.getLong("org.kie.jbpm.lock.maxProcessingTime", 60000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeManagerLockWatcherSingletonService reference(Long watchLockPolling, Long maxLockProcessingTime) {
        RuntimeManagerLockWatcherSingletonService runtimeManagerLockWatcherSingletonService = SERVICE;
        synchronized (runtimeManagerLockWatcherSingletonService) {
            SERVICE.setMaxLockProcessingTime(maxLockProcessingTime);
            SERVICE.setWatchLockPolling(watchLockPolling);
            SERVICE.start();
            return SERVICE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActive() {
        RuntimeManagerLockWatcherSingletonService runtimeManagerLockWatcherSingletonService = SERVICE;
        synchronized (runtimeManagerLockWatcherSingletonService) {
            return RuntimeManagerLockWatcherSingletonService.SERVICE.executorService != null;
        }
    }

    private class RuntimeManagerLockReaper
    implements Runnable {
        private RuntimeManagerLockReaper() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    long maxTimeToWait = RuntimeManagerLockWatcherSingletonService.this.tryForcedUnlock();
                    Thread.sleep(maxTimeToWait);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class LockWatchInfo
    implements Comparable<LockWatchInfo> {
        RuntimeManagerLock lock;
        long processInstanceId;
        long startTime;

        public LockWatchInfo(long processInstanceId, RuntimeManagerLock lock) {
            this.processInstanceId = processInstanceId;
            this.lock = lock;
            this.startTime = System.currentTimeMillis();
        }

        public long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public long getCurrentProcessingTime() {
            return System.currentTimeMillis() - this.startTime;
        }

        @Override
        public int compareTo(LockWatchInfo o) {
            return Long.valueOf(this.startTime).compareTo(o.startTime);
        }

        public String toString() {
            return "[Lock Watch for " + this.processInstanceId + " locked since " + this.startTime + "]";
        }
    }
}

