/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.InternalJaxbWrapper;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.User;

@XmlType(name="attachment")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbAttachment
extends AbstractJaxbTaskObject<Attachment>
implements Attachment {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="string")
    private String name;
    @XmlElement
    @XmlSchemaType(name="string")
    private String contentType;
    @XmlElement
    @XmlSchemaType(name="dateTime")
    private Date attachedAt;
    @XmlElement(name="attached-by")
    @XmlSchemaType(name="string")
    private String attachedBy;
    @XmlElement
    @XmlSchemaType(name="int")
    private Integer size;
    @XmlElement(name="attachment-content-id")
    @XmlSchemaType(name="long")
    private Long attachmentContentId;

    public JaxbAttachment() {
        super(Attachment.class);
    }

    public JaxbAttachment(Attachment attachment) {
        super(attachment, Attachment.class);
        User attacher = attachment.getAttachedBy();
        if (attacher != null) {
            this.attachedBy = attacher.getId();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getAttachedAt() {
        return this.attachedAt;
    }

    public User getAttachedBy() {
        return new InternalJaxbWrapper.GetterUser(this.attachedBy);
    }

    public String getAttachedById() {
        return this.attachedBy;
    }

    public int getSize() {
        return JaxbAttachment.whenNull(this.size, -1);
    }

    public long getAttachmentContentId() {
        return JaxbAttachment.whenNull(this.attachmentContentId, -1L);
    }
}

