/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query;

import java.util.List;
import java.util.stream.Collectors;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.jbpm.kie.services.impl.query.AggregateColumnFilter;
import org.jbpm.kie.services.impl.query.ExtraColumnFilter;
import org.jbpm.kie.services.impl.query.GroupColumnFilter;
import org.jbpm.services.api.query.QueryParamBuilder;
import org.jbpm.services.api.query.model.QueryParam;

public class CoreFunctionQueryParamBuilder
implements QueryParamBuilder<Object> {
    private QueryParam[] filterParams;
    private int index = 0;

    public CoreFunctionQueryParamBuilder(QueryParam ... filterParams) {
        this.filterParams = filterParams;
    }

    public Object build() {
        if (this.filterParams.length == 0 || this.filterParams.length <= this.index) {
            return null;
        }
        QueryParam param = this.filterParams[this.index];
        ++this.index;
        if ("group".equalsIgnoreCase(param.getOperator())) {
            if (param.getValue().size() > 1) {
                return new GroupColumnFilter(param.getColumn(), (String)param.getValue().get(0), (String)param.getValue().get(1), (Integer)param.getValue().get(2));
            }
            return new GroupColumnFilter(param.getColumn(), (String)param.getValue().get(0), null, -1);
        }
        ColumnFilter filter = this.buildExpressionColumnFilter(param);
        if (filter != null) {
            return filter;
        }
        AggregateFunctionType aggregationType = AggregateFunctionType.getByName((String)param.getOperator());
        if (aggregationType != null) {
            return new AggregateColumnFilter(aggregationType, param.getColumn(), (String)param.getValue().get(0));
        }
        return new ExtraColumnFilter(param.getColumn(), (String)param.getValue().get(0));
    }

    private ColumnFilter buildExpressionColumnFilter(Object paramValue) {
        if (!(paramValue instanceof QueryParam)) {
            return (ColumnFilter)paramValue;
        }
        QueryParam param = (QueryParam)paramValue;
        CoreFunctionType type = CoreFunctionType.getByName((String)param.getOperator());
        if (type != null) {
            return new CoreFunctionFilter(param.getColumn(), type, param.getValue());
        }
        LogicalExprType logicalExprType = LogicalExprType.getByName((String)param.getOperator());
        if (logicalExprType != null) {
            List elements = param.getValue();
            List filters = elements.stream().map(this::buildExpressionColumnFilter).collect(Collectors.toList());
            return new LogicalExprFilter(param.getColumn(), logicalExprType, filters);
        }
        return null;
    }
}

