/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.core.common.NetworkNode;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.util.debug.DefaultNodeInfo;
import org.drools.core.util.debug.NodeInfo;

public class StatefulKnowledgeSessionInfo {
    private StatefulKnowledgeSessionImpl session;
    private Map<NetworkNode, DefaultNodeInfo> nodesInfo = new TreeMap<NetworkNode, DefaultNodeInfo>(new Comparator<NetworkNode>(){

        @Override
        public int compare(NetworkNode o1, NetworkNode o2) {
            return o1.getId() - o2.getId();
        }
    });
    private List<String> log = new ArrayList<String>();
    private SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");

    public InternalKnowledgePackage[] getPackages() {
        return ((KnowledgeBaseImpl)this.session.getKnowledgeBase()).getPackages();
    }

    public int getNodeCount() {
        return ((KnowledgeBaseImpl)this.session.getKnowledgeBase()).getNodeCount();
    }

    public int getExternalFactCount() {
        return this.session.getObjectStore().size();
    }

    public void assign(NetworkNode snode, RuleImpl rule) {
        DefaultNodeInfo info = this.nodesInfo.get(snode);
        info.assign(rule);
    }

    public boolean visited(NetworkNode node) {
        return this.nodesInfo.containsKey(node);
    }

    public DefaultNodeInfo getNodeInfo(NetworkNode node) {
        return this.nodesInfo.get(node);
    }

    public void addNodeInfo(NetworkNode node, DefaultNodeInfo dni) {
        this.nodesInfo.put(node, dni);
    }

    public void info(String msg) {
        this.log(msg, " [INFO] - ");
    }

    public void warn(String msg) {
        this.log(msg, " [WARN] - ");
    }

    public void error(String msg) {
        this.log(msg, " [ERRO] - ");
    }

    private void log(String msg, String lvl) {
        this.log.add(this.df.format(System.currentTimeMillis()) + lvl + msg);
    }

    public List<String> getLog() {
        return this.log;
    }

    public Collection<? extends NodeInfo> getNodeInfos() {
        return this.nodesInfo.values();
    }

    public StatefulKnowledgeSessionImpl getSession() {
        return this.session;
    }

    public void setSession(StatefulKnowledgeSessionImpl session) {
        this.session = session;
    }
}

