/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.util.SQLCommandUtil;
import org.jbpm.test.persistence.scripts.util.SQLScriptUtil;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.jbpm.test.persistence.scripts.util.TestsUtil;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.jbpm.test.persistence.util.ProcessCreatorForHelp;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Environment;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPersistenceContextBase {
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static final Logger logger = LoggerFactory.getLogger(TestPersistenceContextBase.class);
    protected HashMap<String, Object> context;
    protected EntityManagerFactory entityManagerFactory;
    protected JtaTransactionManager transactionManager;
    protected Environment environment;
    protected Properties dataSourceProperties = PersistenceUtil.getDatasourceProperties();
    protected final DatabaseType databaseType = TestsUtil.getDatabaseType(this.dataSourceProperties);

    public static TestPersistenceContextBase createAndInitContext(PersistenceUnit persistenceUnit) {
        TestPersistenceContextBase testPersistenceContextBase = new TestPersistenceContextBase();
        testPersistenceContextBase.init(persistenceUnit);
        return testPersistenceContextBase;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void init(PersistenceUnit persistenceUnit) {
        try {
            this.context = PersistenceUtil.setupWithPoolingDataSource(persistenceUnit.getName(), persistenceUnit.getDataSourceName());
            this.entityManagerFactory = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            this.environment = PersistenceUtil.createEnvironment(this.context);
            Object tm = this.environment.get("org.kie.transaction.TransactionManager");
            this.transactionManager = new JtaTransactionManager(this.environment.get("org.kie.transaction.Transaction"), this.environment.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
        }
        catch (RuntimeException ex) {
            logger.error("Failed to initialize persistence unit {}", (Object)persistenceUnit, (Object)ex);
            if (this.entityManagerFactory != null) {
                this.entityManagerFactory.close();
            }
            throw ex;
        }
    }

    public void clean() {
        PersistenceUtil.cleanUp(this.context);
    }

    public void executeScripts(File scriptsRootFolder, ScriptFilter scriptFilter) throws IOException, SQLException {
        this.testIsInitialized();
        this.executeScripts(scriptsRootFolder, scriptFilter, (DataSource)this.context.get("org.droolsjbpm.persistence.datasource"), null);
    }

    public void executeScripts(File scriptsRootFolder, ScriptFilter scriptFilter, DataSource dataSource, String defaultSchema) throws IOException, SQLException {
        File[] sqlScripts = TestsUtil.getDDLScriptFilesByDatabaseType(scriptsRootFolder, this.databaseType, scriptFilter);
        if (sqlScripts.length == 0 && scriptFilter.hasOption(ScriptFilter.Option.DISALLOW_EMTPY_RESULTS)) {
            throw new RuntimeException("No create sql files found for db type " + (Object)((Object)this.databaseType) + " in folder " + scriptsRootFolder.getAbsolutePath());
        }
        try (Connection connection = dataSource.getConnection();){
            connection.setAutoCommit(false);
            if (defaultSchema != null && !defaultSchema.isEmpty()) {
                connection.setSchema(defaultSchema);
            }
            for (File script : sqlScripts) {
                logger.info("Executing script {}", (Object)script.getName());
                List<String> scriptCommands = SQLScriptUtil.getCommandsFromScript(script, this.databaseType);
                for (String command : scriptCommands) {
                    logger.debug("query {} ", (Object)command);
                    PreparedStatement statement = this.preparedStatement(connection, command);
                    this.executeStatement(scriptFilter.hasOption(ScriptFilter.Option.THROW_ON_SCRIPT_ERROR), statement);
                }
            }
            connection.commit();
        }
    }

    private PreparedStatement preparedStatement(Connection conn, String command) throws SQLException {
        PreparedStatement statement = this.databaseType == DatabaseType.SQLSERVER || this.databaseType == DatabaseType.SQLSERVER2008 || this.databaseType == DatabaseType.SYBASE ? conn.prepareStatement(SQLCommandUtil.preprocessCommandSqlServer(command, this.dataSourceProperties)) : conn.prepareStatement(command);
        return statement;
    }

    private void executeStatement(boolean createFiles, PreparedStatement statement) throws SQLException {
        try {
            statement.execute();
            statement.close();
        }
        catch (SQLException ex) {
            if (createFiles) {
                throw ex;
            }
            logger.warn("Dropping statement failed: {} ", (Object)ex.getMessage());
        }
    }

    public void startAndPersistSomeProcess(String processId) {
        this.testIsInitialized();
        KieBase kbase = this.createKieBase(processId);
        StatefulKnowledgeSession session = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.environment);
        session.startProcess(processId);
    }

    public StatefulKnowledgeSession loadPersistedSession(Long sessionId, String processIdForKieBase) {
        this.testIsInitialized();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)this.createKieBase(processIdForKieBase), null, (Environment)this.environment);
    }

    public int getStoredProcessesCount() {
        return this.getStoredEntitiesCount("ProcessInstanceInfo");
    }

    public int getStoredSessionsCount() {
        return this.getStoredEntitiesCount("SessionInfo");
    }

    private int getStoredEntitiesCount(String entityClassName) {
        this.testIsInitialized();
        boolean txOwner = this.transactionManager.begin();
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            List entitiesList = entityManager.createQuery(new StringBuffer("SELECT p FROM ").append(entityClassName).append(" p").toString()).getResultList();
            if (entitiesList == null) {
                int n = 0;
                return n;
            }
            int n = entitiesList.size();
            return n;
        }
        catch (Exception ex) {
            logger.error("Error while getting store entities count for entity {}", (Object)entityClassName, (Object)ex);
            this.transactionManager.rollback(txOwner);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            entityManager.close();
            this.transactionManager.commit(txOwner);
        }
    }

    protected void testIsInitialized() {
        if (this.context == null) {
            throw new IllegalStateException("TestContext is not initialized! Call TestContext.init() before using it.");
        }
    }

    private KieBase createKieBase(String ... processIds) {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        for (String processId : processIds) {
            ((KnowledgeBaseImpl)kbase).addProcess((Process)ProcessCreatorForHelp.newSimpleEventProcess(processId, "test"));
        }
        return kbase;
    }
}

