/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.jbpm.kie.services.impl.query.mapper.AbstractQueryMapper;
import org.jbpm.services.api.query.QueryResultMapper;

public class RawListQueryMapper
extends AbstractQueryMapper<List<Object>>
implements QueryResultMapper<List<List<Object>>> {
    private static final long serialVersionUID = 5935133069234696714L;

    public static RawListQueryMapper get() {
        return new RawListQueryMapper();
    }

    public List<List<Object>> map(Object result) {
        if (result instanceof DataSet) {
            DataSet dataSetResult = (DataSet)result;
            ArrayList<List<Object>> mappedResult = new ArrayList<List<Object>>();
            if (dataSetResult != null) {
                for (int i = 0; i < dataSetResult.getRowCount(); ++i) {
                    Object row = this.buildInstance(dataSetResult, i);
                    mappedResult.add((List<Object>)row);
                }
            }
            return mappedResult;
        }
        throw new IllegalArgumentException("Unsupported result for mapping " + result);
    }

    @Override
    protected List<Object> buildInstance(DataSet dataSetResult, int index) {
        ArrayList<Object> row = new ArrayList<Object>();
        for (DataColumn column : dataSetResult.getColumns()) {
            row.add(dataSetResult.getColumnById(column.getId()).getValues().get(index));
        }
        return row;
    }

    public String getName() {
        return "RawList";
    }

    public Class<?> getType() {
        return List.class;
    }

    public QueryResultMapper<List<List<Object>>> forColumnMapping(Map<String, String> columnMapping) {
        return new RawListQueryMapper();
    }
}

