/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.time.impl.DefaultTimerJobFactoryManager;
import org.drools.core.time.impl.ThreadSafeTrackableTimeJobFactoryManager;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TrackableTimeJobFactoryManager;

public abstract class TimerJobFactoryType {
    public static final TimerJobFactoryType DEFAULT = new TimerJobFactoryType("default"){

        @Override
        public TimerJobFactoryManager createInstance() {
            return DefaultTimerJobFactoryManager.instance;
        }
    };
    public static final TimerJobFactoryType TRACKABLE = new TimerJobFactoryType("trackable"){

        @Override
        public TimerJobFactoryManager createInstance() {
            return new TrackableTimeJobFactoryManager();
        }
    };
    public static final TimerJobFactoryType THREAD_SAFE_TRACKABLE = new TimerJobFactoryType("thread_safe_trackable"){

        @Override
        public TimerJobFactoryManager createInstance() {
            return new ThreadSafeTrackableTimeJobFactoryManager();
        }
    };
    public static final TimerJobFactoryType JPA = new TimerJobFactoryType("jpa"){

        @Override
        public TimerJobFactoryManager createInstance() {
            try {
                return (TimerJobFactoryManager)Class.forName("org.drools.persistence.jpa.JpaTimeJobFactoryManager").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Map<String, TimerJobFactoryType> registry = new HashMap<String, TimerJobFactoryType>();
    private final String string;

    public static void register(TimerJobFactoryType type) {
        if (type != null && type.getId() != null) {
            registry.put(type.getId(), type);
        }
    }

    public abstract TimerJobFactoryManager createInstance();

    public TimerJobFactoryType(String string) {
        this.string = string;
    }

    public String toExternalForm() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public String getId() {
        return this.string;
    }

    public static TimerJobFactoryType resolveTimerJobFactoryType(String id) {
        TimerJobFactoryType type = registry.get(id);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Illegal enum value '" + id + "' for TimerJobFactoryType");
    }

    static {
        TimerJobFactoryType.register(DEFAULT);
        TimerJobFactoryType.register(TRACKABLE);
        TimerJobFactoryType.register(THREAD_SAFE_TRACKABLE);
        TimerJobFactoryType.register(JPA);
    }
}

