/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.kie.services.impl.query.preprocessor.UserTasksPreprocessor;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessAdminPreprocessor
extends UserTasksPreprocessor {
    public static final String ADMIN_USER = System.getProperty("org.jbpm.ht.admin.user", "Administrator");
    public static final String ADMIN_GROUP = System.getProperty("org.jbpm.ht.admin.group", "Administrators");
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessAdminPreprocessor.class);
    private IdentityProvider identityProvider;

    public BusinessAdminPreprocessor(IdentityProvider identityProvider, DataSetMetadata metadata) {
        super(metadata);
        this.identityProvider = identityProvider;
    }

    @Override
    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null) {
            return;
        }
        if (ADMIN_USER.equals(this.identityProvider.getName()) || this.identityProvider.getRoles().stream().filter(s -> s.equals(ADMIN_GROUP)).findFirst().isPresent()) {
            return;
        }
        ColumnFilter columnFilter = FilterFactory.equalsTo((String)"TASKID", (Comparable)Integer.valueOf(-1));
        LOGGER.debug("Adding column filter: {}", (Object)columnFilter);
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            lookup.addOperation(new DataSetOp[]{filter});
        }
        super.preprocess(lookup);
    }
}

