/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.api;

import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.jta.JtaTransactionSynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSynchronizationRegistryHelper {
    private static final Logger logger = LoggerFactory.getLogger(TransactionSynchronizationRegistryHelper.class);

    public static void registerTransactionSynchronization(Object tsro, TransactionSynchronization ts) {
        TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)tsro;
        tsr.registerInterposedSynchronization((Synchronization)new JtaTransactionSynchronizationAdapter(ts));
    }

    public static void putResource(Object tsro, Object key, Object resource) {
        TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)tsro;
        try {
            tsr.putResource(key, resource);
        }
        catch (IllegalStateException e) {
            if (resource != null) {
                logger.warn("Unable to put resource {} value {} due to {}", new Object[]{key, resource, e.getMessage()});
            }
        }
        catch (Exception e) {
            logger.warn("Unable to put resource {} value {} due to {}", new Object[]{key, resource, e.getMessage()});
        }
    }

    public static Object getResource(Object tsro, Object key) {
        TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)tsro;
        try {
            return tsr.getResource(key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

