/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.kie.services.impl.admin.TimerInstanceImpl;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

public class ListTimersCommand
implements ExecutableCommand<List<org.jbpm.services.api.admin.TimerInstance>>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = -8252686458877022330L;
    private long processInstanceId;

    public ListTimersCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public List<org.jbpm.services.api.admin.TimerInstance> execute(Context context) {
        ArrayList<org.jbpm.services.api.admin.TimerInstance> timers = new ArrayList<org.jbpm.services.api.admin.TimerInstance>();
        KieSession kieSession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        TimerManager tm = this.getTimerManager(kieSession);
        RuleFlowProcessInstance wfp = (RuleFlowProcessInstance)kieSession.getProcessInstance(this.processInstanceId, true);
        if (wfp == null) {
            throw new ProcessInstanceNotFoundException("No process instance can be found for id " + this.processInstanceId);
        }
        this.processNodeInstance(tm, (NodeInstanceContainer)wfp, timers);
        return timers;
    }

    private TimerManager getTimerManager(KieSession ksession) {
        KieSession internal = ksession;
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            internal = ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession();
        }
        return ((InternalProcessRuntime)((StatefulKnowledgeSessionImpl)internal).getProcessRuntime()).getTimerManager();
    }

    private TimerInstanceImpl buildTimer(TimerInstance timerInstance) {
        TimerInstanceImpl timer = new TimerInstanceImpl();
        if (timerInstance != null) {
            timer.setActivationTime(timerInstance.getActivated());
            timer.setLastFireTime(timerInstance.getLastTriggered());
            timer.setNextFireTime(new Date(timerInstance.getActivated().getTime() + timerInstance.getDelay()));
            timer.setDelay(timerInstance.getDelay());
            timer.setPeriod(timerInstance.getPeriod());
            timer.setRepeatLimit(timerInstance.getRepeatLimit());
            timer.setId(timerInstance.getId());
            timer.setTimerId(timerInstance.getTimerId());
            timer.setProcessInstanceId(timerInstance.getProcessInstanceId());
            timer.setSessionId(timerInstance.getSessionId());
        }
        return timer;
    }

    protected void processNodeInstance(TimerManager tm, NodeInstanceContainer container, List<org.jbpm.services.api.admin.TimerInstance> timers) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            StateBasedNodeInstance sbni;
            List timerList;
            if (((NodeInstanceImpl)nodeInstance).getSlaTimerId() != -1L) {
                TimerInstance timer = (TimerInstance)tm.getTimerMap().get(((NodeInstanceImpl)nodeInstance).getSlaTimerId());
                TimerInstanceImpl details = this.buildTimer(timer);
                details.setTimerName("[SLA]" + this.resolveVariable(nodeInstance.getNodeName(), nodeInstance));
                timers.add(details);
            }
            if (nodeInstance instanceof TimerNodeInstance) {
                TimerNodeInstance tni = (TimerNodeInstance)nodeInstance;
                TimerInstance timer = (TimerInstance)tm.getTimerMap().get(tni.getTimerId());
                TimerInstanceImpl details = this.buildTimer(timer);
                details.setTimerName(this.resolveVariable(timer.getName(), (NodeInstance)tni));
                timers.add(details);
            } else if (nodeInstance instanceof StateBasedNodeInstance && (timerList = (sbni = (StateBasedNodeInstance)nodeInstance).getTimerInstances()) != null) {
                for (Long timerId : timerList) {
                    TimerInstance timer = (TimerInstance)tm.getTimerMap().get(timerId);
                    TimerInstanceImpl details = this.buildTimer(timer);
                    details.setTimerName(this.resolveVariable(timer.getName(), (NodeInstance)sbni));
                    timers.add(details);
                }
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.processNodeInstance(tm, (NodeInstanceContainer)nodeInstance, timers);
        }
    }

    protected String resolveVariable(String s, NodeInstance pi) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            Object variableValue = pi.getVariable(paramName);
            String variableValueString = variableValue == null ? "" : variableValue.toString();
            replacements.put(paramName, variableValueString);
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    public void setProcessInstanceId(Long procInstId) {
        this.processInstanceId = procInstId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }
}

