/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.group;

import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.GroupStrategy;

public class ColumnGroup {
    protected String sourceId = null;
    protected String columnId = null;
    protected GroupStrategy strategy = GroupStrategy.DYNAMIC;
    protected int maxIntervals = 15;
    protected String intervalSize = null;
    protected boolean emptyIntervals = false;
    protected boolean ascendingOrder = true;
    protected Month firstMonthOfYear;
    protected DayOfWeek firstDayOfWeek;
    private boolean isPostEnabled = true;

    public ColumnGroup() {
    }

    public ColumnGroup(String columnId, String newColumnId) {
        this.sourceId = columnId;
        this.columnId = newColumnId;
    }

    public ColumnGroup(String columnId, String newColumnId, GroupStrategy strategy) {
        this.sourceId = columnId;
        this.columnId = newColumnId;
        this.strategy = strategy;
    }

    public ColumnGroup(String columnId, String newColumnId, GroupStrategy strategy, int maxIntervals, String intervalSize) {
        this.sourceId = columnId;
        this.columnId = newColumnId;
        this.strategy = strategy;
        this.maxIntervals = maxIntervals;
        this.intervalSize = intervalSize;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public GroupStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(GroupStrategy strategy) {
        this.strategy = strategy;
    }

    public int getMaxIntervals() {
        return this.maxIntervals;
    }

    public void setMaxIntervals(int maxIntervals) {
        this.maxIntervals = maxIntervals;
    }

    public String getIntervalSize() {
        return this.intervalSize;
    }

    public void setIntervalSize(String intervalSize) {
        this.intervalSize = intervalSize;
    }

    public boolean areEmptyIntervalsAllowed() {
        return this.emptyIntervals;
    }

    public void setEmptyIntervalsAllowed(boolean emptyIntervals) {
        this.emptyIntervals = emptyIntervals;
    }

    public boolean isAscendingOrder() {
        return this.ascendingOrder;
    }

    public void setAscendingOrder(boolean ascending) {
        this.ascendingOrder = ascending;
    }

    public Month getFirstMonthOfYear() {
        return this.firstMonthOfYear == null ? (this.isAscendingOrder() ? Month.JANUARY : Month.DECEMBER) : this.firstMonthOfYear;
    }

    public void setFirstMonthOfYear(Month firstMonthOfYear) {
        this.firstMonthOfYear = firstMonthOfYear;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek == null ? (this.isAscendingOrder() ? DayOfWeek.MONDAY : DayOfWeek.SUNDAY) : this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public ColumnGroup cloneInstance() {
        ColumnGroup clone = new ColumnGroup();
        clone.columnId = this.columnId;
        clone.sourceId = this.sourceId;
        clone.strategy = this.strategy;
        clone.maxIntervals = this.maxIntervals;
        clone.intervalSize = this.intervalSize;
        clone.emptyIntervals = this.emptyIntervals;
        clone.ascendingOrder = this.ascendingOrder;
        clone.firstDayOfWeek = this.firstDayOfWeek;
        clone.firstMonthOfYear = this.firstMonthOfYear;
        return clone;
    }

    public boolean equals(Object obj) {
        try {
            ColumnGroup other = (ColumnGroup)obj;
            if (this.sourceId != null && !this.sourceId.equals(other.sourceId)) {
                return false;
            }
            if (this.columnId != null && !this.columnId.equals(other.columnId)) {
                return false;
            }
            if (this.strategy != null && !this.strategy.equals((Object)other.strategy)) {
                return false;
            }
            if (this.intervalSize != null && !this.intervalSize.equals(other.intervalSize)) {
                return false;
            }
            if (this.emptyIntervals != other.emptyIntervals) {
                return false;
            }
            return this.maxIntervals == other.maxIntervals;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("column=").append(this.sourceId).append(" ");
        out.append("strategy=").append((Object)this.strategy).append(" ");
        if (this.intervalSize != null) {
            out.append("intervalSize=").append(this.intervalSize).append(" ");
        }
        out.append("emptyIntervals=").append(this.emptyIntervals).append(" ");
        out.append("maxIntervals=").append(this.maxIntervals);
        return out.toString();
    }

    public boolean isPostEnabled() {
        return this.isPostEnabled;
    }

    public void setPostEnabled(boolean isPostEnabled) {
        this.isPostEnabled = isPostEnabled;
    }
}

