/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.util.concurrent.atomic.AtomicLong;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.JobNameHelper;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.services.ejb.timer.EJBTimerScheduler;
import org.jbpm.services.ejb.timer.EjbGlobalJobHandle;

public class EjbSchedulerService
implements GlobalSchedulerService {
    private static final Boolean TRANSACTIONAL = Boolean.parseBoolean(System.getProperty("org.jbpm.ejb.timer.tx", "true"));
    private AtomicLong idCounter = new AtomicLong();
    private TimerService globalTimerService;
    private EJBTimerScheduler scheduler;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor((GlobalSchedulerService)this);

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        long id = this.idCounter.getAndIncrement();
        String jobName = this.getJobName(ctx, id);
        EjbGlobalJobHandle jobHandle = new EjbGlobalJobHandle(id, jobName, ((GlobalTimerService)this.globalTimerService).getTimerServiceId());
        TimerJobInstance jobInstance = null;
        if (!this.isNewTimer(ctx) && (jobInstance = this.scheduler.getTimerByName(jobName)) != null) {
            return jobInstance.getJobHandle();
        }
        jobInstance = this.globalTimerService.getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, (InternalSchedulerService)this.globalTimerService);
        jobHandle.setTimerJobInstance(jobInstance);
        this.interceptor.internalSchedule(jobInstance);
        return jobHandle;
    }

    public boolean removeJob(JobHandle jobHandle) {
        return this.scheduler.removeJob(jobHandle);
    }

    public void invalidate(JobHandle jobHandle) {
        this.scheduler.evictCache(jobHandle);
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        this.scheduler.internalSchedule(timerJobInstance);
    }

    public void initScheduler(TimerService timerService) {
        this.globalTimerService = timerService;
        try {
            this.scheduler = (EJBTimerScheduler)InitialContext.doLookup("java:module/EJBTimerScheduler");
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to find EJB scheduler for jBPM timer service", e);
        }
    }

    public void shutdown() {
    }

    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return new EjbGlobalJobHandle(-1L, this.getJobName((JobContext)ctx, -1L), ((GlobalTimerService)this.globalTimerService).getTimerServiceId());
    }

    public boolean isTransactional() {
        return TRANSACTIONAL;
    }

    public boolean retryEnabled() {
        return false;
    }

    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        return true;
    }

    protected String getJobName(JobContext ctx, long id) {
        return JobNameHelper.getJobName((JobContext)ctx, (long)id);
    }

    private boolean isNewTimer(JobContext ctx) {
        return ctx instanceof TimerManager.ProcessJobContext && ((TimerManager.ProcessJobContext)ctx).isNewTimer();
    }
}

