/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.impl;

import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DefinitionServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBRemote;
import org.jbpm.services.ejb.api.ExecutorServiceEJB;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.impl.FormManagerServiceEJBImpl;
import org.jbpm.services.ejb.impl.identity.EJBContextIdentityProvider;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.internal.runtime.manager.deploy.TransientNamedObjectModel;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@Lock(value=LockType.WRITE)
public class DeploymentServiceEJBImpl
extends KModuleDeploymentService
implements ListenerSupport,
DeploymentService,
DeploymentServiceEJBLocal,
DeploymentServiceEJBRemote {
    private static final String EXECUTOR_EJB_JNDI_NAME = System.getProperty("org.jbpm.executor.service.ejb-jndi", "jndi:java:module/ExecutorServiceEJBImpl");
    @Inject
    private Instance<IdentityProvider> identityProvider;
    private EJBContext context;
    private boolean isExecutorAvailable = false;

    @PostConstruct
    public void onInit() {
        this.isExecutorAvailable = this.isExecutorOnClasspath();
        if (this.identityProvider.isUnsatisfied()) {
            this.setIdentityProvider(new EJBContextIdentityProvider(this.context));
        } else {
            this.setIdentityProvider((IdentityProvider)this.identityProvider.get());
        }
        this.setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        super.onInit();
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
    }

    @Resource
    public void setContext(EJBContext context) {
        this.context = context;
    }

    @PersistenceUnit(unitName="org.jbpm.domain")
    public void setEmf(EntityManagerFactory emf) {
        super.setEmf(emf);
    }

    @EJB(beanInterface=DefinitionServiceEJBLocal.class)
    public void setBpmn2Service(DefinitionService bpmn2Service) {
        super.setBpmn2Service(bpmn2Service);
        super.addListener((DeploymentEventListener)bpmn2Service);
    }

    @EJB(beanInterface=RuntimeDataServiceEJBLocal.class)
    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        super.setRuntimeDataService(runtimeDataService);
        super.addListener((DeploymentEventListener)runtimeDataService);
    }

    @EJB(beanInterface=FormManagerServiceEJBImpl.class)
    public void setFormManagerService(FormManagerService formManagerService) {
        super.setFormManagerService(formManagerService);
    }

    @EJB(beanInterface=ExecutorServiceEJB.class)
    public void setExecutorService(ExecutorService executorService) {
        super.setExecutorService(executorService);
    }

    public void deploy(String groupId, String artifactId, String version) {
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version);
        this.addAsyncHandler(unit);
        super.deploy((DeploymentUnit)unit);
    }

    public void deploy(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version, kbaseName, ksessionName);
        this.addAsyncHandler(unit);
        super.deploy((DeploymentUnit)unit);
    }

    public void deploy(String groupId, String artifactId, String version, String kbaseName, String ksessionName, String strategy) {
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version, kbaseName, ksessionName, strategy);
        this.addAsyncHandler(unit);
        super.deploy((DeploymentUnit)unit);
    }

    public void deploy(DeploymentUnit unit) {
        this.addAsyncHandler((KModuleDeploymentUnit)unit);
        super.deploy(unit);
    }

    public void undeploy(String deploymentId) {
        DeployedUnit deployed = this.getDeployedUnit(deploymentId);
        if (deployed != null) {
            super.undeploy(deployed.getDeploymentUnit());
        }
    }

    public void undeploy(String deploymentId, Function<DeploymentUnit, Boolean> beforeUndeploy) {
        DeployedUnit deployed = this.getDeployedUnit(deploymentId);
        if (deployed != null) {
            super.undeploy(deployed.getDeploymentUnit(), beforeUndeploy);
        }
    }

    protected void addAsyncHandler(KModuleDeploymentUnit unit) {
        if (this.isExecutorAvailable) {
            DeploymentDescriptor descriptor = unit.getDeploymentDescriptor();
            if (descriptor == null) {
                descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
            }
            descriptor.getBuilder().addWorkItemHandler((NamedObjectModel)new TransientNamedObjectModel("ejb", "async", "org.jbpm.executor.impl.wih.AsyncWorkItemHandler", new Object[]{EXECUTOR_EJB_JNDI_NAME, "org.jbpm.executor.commands.PrintOutCommand"}));
            unit.setDeploymentDescriptor(descriptor);
        }
    }

    protected boolean isExecutorOnClasspath() {
        try {
            Class.forName("org.jbpm.executor.impl.wih.AsyncWorkItemHandler");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

