/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.runtime.Context;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.DeadlineSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="init-deadlines-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class InitDeadlinesCommand
extends TaskCommand<Void> {
    private static final long serialVersionUID = -8095766991770311489L;
    private static final Logger logger = LoggerFactory.getLogger(InitDeadlinesCommand.class);
    private final String deploymentId;
    private final Class<List<DeadlineSummary>> resultClass;

    public InitDeadlinesCommand() {
        this(null);
    }

    public InitDeadlinesCommand(String deploymentId) {
        this.deploymentId = deploymentId;
        this.resultClass = ClassUtil.castClass(List.class);
    }

    public Void execute(Context context) {
        TaskContext ctx = (TaskContext)context;
        TaskPersistenceContext persistenceContext = ctx.getPersistenceContext();
        TaskDeadlinesService deadlineService = ctx.getTaskDeadlinesService();
        try {
            this.processDeadlines("UnescalatedStartDeadlines", TaskDeadlinesService.DeadlineType.START, persistenceContext, deadlineService);
            this.processDeadlines("UnescalatedEndDeadlines", TaskDeadlinesService.DeadlineType.END, persistenceContext, deadlineService);
        }
        catch (Exception e) {
            logger.error("Error when executing deadlines", (Throwable)e);
        }
        return null;
    }

    private void processDeadlines(String queryName, TaskDeadlinesService.DeadlineType deadlineType, TaskPersistenceContext persistenceContext, TaskDeadlinesService deadlineService) {
        List resultList = this.deploymentId == null ? (List)persistenceContext.queryInTransaction(queryName, this.resultClass) : (List)persistenceContext.queryWithParametersInTransaction(queryName + "ByDeployment", Collections.singletonMap("deploymentId", this.deploymentId), this.resultClass);
        long now = System.currentTimeMillis();
        for (DeadlineSummary summary : resultList) {
            deadlineService.schedule(summary.getTaskId(), summary.getDeadlineId(), summary.getDate().getTime() - now, deadlineType);
        }
    }
}

