/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.impl.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.kie.api.task.TaskEvent;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.TaskEvent;

@Entity
@Table(name="TaskEvent", indexes={@Index(name="IDX_TaskEvent_taskId", columnList="taskId"), @Index(name="IDX_TaskEvent_processInstanceId", columnList="processInstanceId")})
@SequenceGenerator(name="taskEventIdSeq", sequenceName="TASK_EVENT_ID_SEQ")
public class TaskEventImpl
implements org.kie.internal.task.api.model.TaskEvent,
Serializable {
    private static final long serialVersionUID = 6304722095353315479L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="taskEventIdSeq")
    @Column(name="id")
    private Long id;
    @Version
    @Column(name="OPTLOCK")
    private Integer version;
    private Long taskId;
    private Long workItemId;
    @Enumerated(value=EnumType.STRING)
    private TaskEvent.TaskEventType type;
    private Long processInstanceId;
    private String userId;
    private String message;
    private String correlationKey;
    private Integer processType;
    private String currentOwner;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date logTime;

    public TaskEventImpl() {
    }

    public TaskEventImpl(long taskId, TaskEvent.TaskEventType type, String userId) {
        this.taskId = taskId;
        this.type = type;
        this.userId = userId;
        this.logTime = new Date();
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, String userId, Date logTime) {
        this.taskId = taskId;
        this.type = type;
        this.userId = userId;
        this.logTime = logTime;
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, Long processInstanceId, Long workItemId, String userId, Date logTime) {
        this.taskId = taskId;
        this.type = type;
        this.processInstanceId = processInstanceId;
        this.workItemId = workItemId;
        this.userId = userId;
        this.logTime = logTime;
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, Long processInstanceId, Long workItemId, String userId) {
        this(taskId, type, processInstanceId, workItemId, userId, new Date());
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, Long processInstanceId, Long workItemId, String userId, String message) {
        this(taskId, type, processInstanceId, workItemId, userId, new Date());
        this.message = message;
    }

    public TaskEventImpl(TaskEvent event, TaskEvent.TaskEventType type) {
        this(event, type, null);
    }

    public TaskEventImpl(TaskEvent event, TaskEvent.TaskEventType type, String message) {
        InternalTaskData taskData = (InternalTaskData)event.getTask().getTaskData();
        this.taskId = event.getTask().getId();
        this.type = type;
        this.processInstanceId = taskData.getProcessInstanceId();
        this.workItemId = taskData.getWorkItemId();
        this.currentOwner = taskData.getActualOwner() != null ? taskData.getActualOwner().getId() : "";
        this.userId = event.getTaskContext().getUserId();
        this.message = message;
        this.logTime = event.getEventDate();
    }

    public long getId() {
        return this.id;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public TaskEvent.TaskEventType getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Long getWorkItemId() {
        return this.workItemId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public Integer getProcessType() {
        return this.processType;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCurrentOwner() {
        return this.currentOwner;
    }

    public void setCurrentOwner(String currentOwner) {
        this.currentOwner = currentOwner;
    }

    public int hashCode() {
        return Objects.hash(this.currentOwner, this.correlationKey, this.id, this.logTime, this.message, this.processInstanceId, this.processType, this.taskId, this.type, this.userId, this.version, this.workItemId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskEventImpl)) {
            return false;
        }
        TaskEventImpl other = (TaskEventImpl)obj;
        return Objects.equals(this.currentOwner, other.currentOwner) && Objects.equals(this.correlationKey, other.correlationKey) && Objects.equals(this.id, other.id) && Objects.equals(this.logTime, other.logTime) && Objects.equals(this.message, other.message) && Objects.equals(this.processInstanceId, other.processInstanceId) && Objects.equals(this.processType, other.processType) && Objects.equals(this.taskId, other.taskId) && this.type == other.type && Objects.equals(this.userId, other.userId) && Objects.equals(this.version, other.version) && Objects.equals(this.workItemId, other.workItemId);
    }

    public String toString() {
        return "TaskEventImpl [id=" + this.id + ", version=" + this.version + ", taskId=" + this.taskId + ", workItemId=" + this.workItemId + ", type=" + this.type + ", processInstanceId=" + this.processInstanceId + ", userId=" + this.userId + ", message=" + this.message + ", correlationKey=" + this.correlationKey + ", processType=" + this.processType + ", actualOwner=" + this.currentOwner + ", logTime=" + this.logTime + "]";
    }
}

