/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.Arrays;
import java.util.List;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.runtime.Context;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

public class RemovePeopleAssignmentsCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private int type;
    private OrganizationalEntity[] entities;

    public RemovePeopleAssignmentsCommand(String userId, long taskId, int type, OrganizationalEntity[] entities) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.type = type;
        this.entities = entities;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        TaskEventSupport taskEventSupport = context.getTaskEventSupport();
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        List<OrganizationalEntity> entityList = Arrays.asList(this.entities);
        TaskLifeCycleEventListener.AssignmentType assignmentType = null;
        taskEventSupport.fireBeforeTaskUpdated(task, (TaskContext)context);
        switch (this.type) {
            case 0: {
                assignmentType = TaskLifeCycleEventListener.AssignmentType.POT_OWNER;
                taskEventSupport.fireBeforeTaskAssignmentsRemovedEvent(task, (TaskContext)context, assignmentType, entityList);
                task.getPeopleAssignments().getPotentialOwners().removeAll(entityList);
                break;
            }
            case 1: {
                assignmentType = TaskLifeCycleEventListener.AssignmentType.EXCL_OWNER;
                taskEventSupport.fireBeforeTaskAssignmentsRemovedEvent(task, (TaskContext)context, assignmentType, entityList);
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().removeAll(entityList);
                break;
            }
            case 2: {
                assignmentType = TaskLifeCycleEventListener.AssignmentType.ADMIN;
                taskEventSupport.fireBeforeTaskAssignmentsRemovedEvent(task, (TaskContext)context, assignmentType, entityList);
                task.getPeopleAssignments().getBusinessAdministrators().removeAll(entityList);
                break;
            }
        }
        context.getPersistenceContext().updateTask(task);
        taskEventSupport.fireAfterTaskAssignmentsRemovedEvent(task, (TaskContext)context, assignmentType, entityList);
        return null;
    }
}

