/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.command.runtime.process.SetProcessInstanceVariablesCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.jbpm.kie.services.impl.CommonUtils;
import org.jbpm.kie.services.impl.VariablesAware;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.services.api.DeploymentNotActiveException;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.WorkItemNotFoundException;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Node;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.utils.LazyLoaded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImpl
implements ProcessService,
VariablesAware {
    private static final Logger logger = LoggerFactory.getLogger(ProcessServiceImpl.class);
    protected DeploymentService deploymentService;
    protected RuntimeDataService dataService;

    public ProcessServiceImpl() {
        ServiceRegistry.get().register(ProcessService.class.getSimpleName(), (Object)this);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setDataService(RuntimeDataService dataService) {
        this.dataService = dataService;
    }

    public Long startProcess(String deploymentId, String processId) {
        return this.startProcess(deploymentId, processId, new HashMap<String, Object>());
    }

    public Long startProcessFromNodeIds(String deploymentId, String processId, Map<String, Object> params, String ... nodeIds) {
        return this.startProcessFromNodeIds(deploymentId, processId, null, params, nodeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long startProcessFromNodeIds(String deploymentId, String processId, CorrelationKey key, Map<String, Object> params, String ... nodeIds) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        if (!deployedUnit.isActive()) {
            throw new DeploymentNotActiveException("Deployment " + deploymentId + " is not active");
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine(this.getContext(params));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance pi = key == null ? ksession.startProcessFromNodeIds(processId, params, nodeIds) : ((CorrelationAwareProcessRuntime)ksession).startProcessFromNodeIds(processId, key, params, nodeIds);
            Long l = pi.getId();
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> computeProcessOutcome(String deploymentId, String processId, Map<String, Object> params) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        if (!deployedUnit.isActive()) {
            throw new DeploymentNotActiveException("Deployment " + deploymentId + " is not active");
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine(this.getContext(params));
        KieSession ksession = engine.getKieSession();
        final HashMap<String, Object> vars = params != null ? new HashMap<String, Object>(params) : new HashMap();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                vars.put(event.getVariableId(), event.getNewValue());
            }
        });
        try {
            ksession.startProcess(processId, params);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
        return vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long startProcess(String deploymentId, String processId, Map<String, Object> params) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        if (!deployedUnit.isActive()) {
            throw new DeploymentNotActiveException("Deployment " + deploymentId + " is not active");
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine(this.getContext(params));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance pi = ksession.startProcess(processId, params);
            Long l = pi.getId();
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public Long startProcess(String deploymentId, String processId, CorrelationKey correlationKey) {
        return this.startProcess(deploymentId, processId, correlationKey, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long startProcess(String deploymentId, String processId, CorrelationKey correlationKey, Map<String, Object> params) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        if (!deployedUnit.isActive()) {
            throw new DeploymentNotActiveException("Deployment " + deploymentId + " is not active");
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine(this.getContext(params));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance pi = ((CorrelationAwareProcessRuntime)ksession).startProcess(processId, correlationKey, params);
            Long l = pi.getId();
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    protected Context<?> getContext(Map<String, Object> params) {
        if (params == null) {
            return ProcessInstanceIdContext.get();
        }
        String caseId = (String)params.get("CaseId");
        if (caseId != null && !caseId.isEmpty()) {
            return CaseContext.get((String)caseId);
        }
        return ProcessInstanceIdContext.get();
    }

    public void abortProcessInstance(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        this.abortProcessInstance(piDesc.getDeploymentId(), processInstanceId);
    }

    public void abortProcessInstance(String deploymentId, Long processInstanceId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ksession.abortProcessInstance(processInstanceId.longValue());
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void abortProcessInstances(List<Long> processInstanceIds) {
        processInstanceIds.forEach(processInstanceId -> {
            try {
                this.abortProcessInstance((Long)processInstanceId);
            }
            catch (ProcessInstanceNotFoundException ex) {
                logger.warn("Process instance with id " + processInstanceId + " was not found", (Throwable)ex);
            }
        });
    }

    public void abortProcessInstances(String deploymentId, List<Long> processInstanceIds) {
        processInstanceIds.forEach(processInstanceId -> {
            try {
                this.abortProcessInstance((Long)processInstanceId);
            }
            catch (ProcessInstanceNotFoundException ex) {
                logger.warn("Process instance with id " + processInstanceId + " was not found", (Throwable)ex);
            }
        });
    }

    public void signalProcessInstance(Long processInstanceId, String signalName, Object event) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        this.signalProcessInstance(piDesc.getDeploymentId(), processInstanceId, signalName, event);
    }

    public void signalProcessInstance(String deploymentId, Long processInstanceId, String signalName, Object event) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        event = this.process(event, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ksession.signalEvent(signalName, event, processInstanceId.longValue());
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void signalProcessInstances(List<Long> processInstanceIds, String signalName, Object event) {
        for (Long processInstanceId : processInstanceIds) {
            this.signalProcessInstance(processInstanceId, signalName, event);
        }
    }

    public void signalProcessInstances(String deploymentId, List<Long> processInstanceIds, String signalName, Object event) {
        for (Long processInstanceId : processInstanceIds) {
            this.signalProcessInstance(deploymentId, processInstanceId, signalName, event);
        }
    }

    public void signalProcessInstanceByCorrelationKey(CorrelationKey correlationKey, String signalName, Object event) {
        ProcessInstanceDesc pi = this.dataService.getProcessInstanceByCorrelationKey(correlationKey);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process with correlation key " + correlationKey + " not found");
        }
        this.signalProcessInstance(pi.getId(), signalName, event);
    }

    public void signalProcessInstanceByCorrelationKey(String deploymentId, CorrelationKey correlationKey, String signalName, Object event) {
        ProcessInstanceDesc pi = this.dataService.getProcessInstanceByCorrelationKey(correlationKey);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process with correlation key " + correlationKey + " not found");
        }
        this.signalProcessInstance(deploymentId, pi.getId(), signalName, event);
    }

    public void signalProcessInstancesByCorrelationKeys(List<CorrelationKey> correlationKeys, String signalName, Object event) {
        if (correlationKeys == null) {
            return;
        }
        correlationKeys.forEach(key -> this.signalProcessInstanceByCorrelationKey((CorrelationKey)key, signalName, event));
    }

    public void signalProcessInstancesByCorrelationKeys(String deploymentId, List<CorrelationKey> correlationKeys, String signalName, Object event) {
        if (correlationKeys == null) {
            return;
        }
        correlationKeys.forEach(key -> this.signalProcessInstanceByCorrelationKey(deploymentId, (CorrelationKey)key, signalName, event));
    }

    public void signalEvent(String deploymentId, String signalName, Object event) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        event = this.process(event, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        manager.signalEvent(signalName, event);
    }

    public ProcessInstance getProcessInstance(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            return null;
        }
        return this.getProcessInstance(piDesc.getDeploymentId(), processInstanceId);
    }

    public ProcessInstance getProcessInstance(String deploymentId, Long processInstanceId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId.longValue());
            return processInstance;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public ProcessInstance getProcessInstance(CorrelationKey key) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceByCorrelationKey(key);
        if (piDesc == null) {
            return null;
        }
        return this.getProcessInstance(piDesc.getDeploymentId(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInstance getProcessInstance(String deploymentId, CorrelationKey key) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)CorrelationKeyContext.get((CorrelationKey)key));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(key);
            return processInstance;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void setProcessVariable(Long processInstanceId, String variableId, Object value) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        this.setProcessVariable(piDesc.getDeploymentId(), processInstanceId, variableId, value);
    }

    public void setProcessVariable(String deploymentId, Long processInstanceId, String variableId, Object value) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        value = this.process(value, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ProcessInstance pi = ksession.getProcessInstance(processInstanceId.longValue());
            if (pi == null) {
                throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
            }
            ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstanceId.longValue(), Collections.singletonMap(variableId, value)));
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void setProcessVariables(Long processInstanceId, Map<String, Object> variables) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        this.setProcessVariables(piDesc.getDeploymentId(), processInstanceId, variables);
    }

    public void setProcessVariables(String deploymentId, Long processInstanceId, Map<String, Object> variables) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        variables = this.process(variables, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ProcessInstance pi = ksession.getProcessInstance(processInstanceId.longValue());
            if (pi == null) {
                throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
            }
            ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstanceId.longValue(), variables));
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public Object getProcessInstanceVariable(Long processInstanceId, String variableName) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        return this.getProcessInstanceVariable(piDesc.getDeploymentId(), processInstanceId, variableName);
    }

    public Object getProcessInstanceVariable(String deploymentId, final Long processInstanceId, final String variableName) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            Object object = ksession.execute((Command)new ExecutableCommand<Object>(){
                private static final long serialVersionUID = -2693525229757876896L;

                public Object execute(org.kie.api.runtime.Context context) {
                    KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                    WorkflowProcessInstance pi = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId.longValue(), true);
                    if (pi == null) {
                        throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
                    }
                    Object variable = pi.getVariable(variableName);
                    if (variable instanceof LazyLoaded) {
                        ((LazyLoaded)variable).load();
                    }
                    return variable;
                }
            });
            return object;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public Map<String, Object> getProcessInstanceVariables(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        return this.getProcessInstanceVariables(piDesc.getDeploymentId(), processInstanceId);
    }

    public Map<String, Object> getProcessInstanceVariables(String deploymentId, Long processInstanceId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)ksession.getProcessInstance(processInstanceId.longValue(), true);
            if (pi == null) {
                throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
            }
            Map variables = pi.getVariables();
            for (Object variable : variables.values()) {
                if (!(variable instanceof LazyLoaded)) continue;
                ((LazyLoaded)variable).load();
            }
            Map map = variables;
            return map;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public Collection<String> getAvailableSignals(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        return this.getAvailableSignals(piDesc.getDeploymentId(), processInstanceId);
    }

    public Collection<String> getAvailableSignals(String deploymentId, Long processInstanceId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId.longValue(), true);
            ArrayList<String> activeSignals = new ArrayList<String>();
            if (processInstance != null) {
                ((ProcessInstanceImpl)processInstance).setProcess(ksession.getKieBase().getProcess(processInstance.getProcessId()));
                Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
                List<String> activeBoundaryNodesSignals = this.getActiveBoundaryNodesSignals(processInstance, activeNodes);
                activeSignals.addAll(this.collectActiveSignals(activeNodes));
                activeSignals.addAll(activeBoundaryNodesSignals);
            }
            ArrayList<String> arrayList = activeSignals;
            return arrayList;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void completeWorkItem(Long id, Map<String, Object> results) {
        NodeInstanceDesc nodeDesc = this.dataService.getNodeInstanceForWorkItem(id);
        if (nodeDesc == null) {
            throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
        }
        this.completeWorkItem(nodeDesc.getDeploymentId(), nodeDesc.getProcessInstanceId(), id, results);
    }

    public void completeWorkItem(String deploymentId, Long processInstanceId, Long id, Map<String, Object> results) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        results = this.process(results, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            WorkItem workItem = ((WorkItemManager)ksession.getWorkItemManager()).getWorkItem(id.longValue());
            if (workItem == null) {
                throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
            }
            ksession.getWorkItemManager().completeWorkItem(id.longValue(), results);
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void abortWorkItem(Long id) {
        NodeInstanceDesc nodeDesc = this.dataService.getNodeInstanceForWorkItem(id);
        if (nodeDesc == null) {
            throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
        }
        this.abortWorkItem(nodeDesc.getDeploymentId(), nodeDesc.getProcessInstanceId(), id);
    }

    public void abortWorkItem(String deploymentId, Long processInstanceId, Long id) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            WorkItem workItem = ((WorkItemManager)ksession.getWorkItemManager()).getWorkItem(id.longValue());
            if (workItem == null) {
                throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
            }
            ksession.getWorkItemManager().abortWorkItem(id.longValue());
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public org.kie.api.runtime.process.WorkItem getWorkItem(Long id) {
        NodeInstanceDesc nodeDesc = this.dataService.getNodeInstanceForWorkItem(id);
        if (nodeDesc == null) {
            throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
        }
        return this.getWorkItem(nodeDesc.getDeploymentId(), nodeDesc.getProcessInstanceId(), id);
    }

    public org.kie.api.runtime.process.WorkItem getWorkItem(String deploymentId, Long processInstanceId, Long id) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            WorkItem workItem = ((WorkItemManager)ksession.getWorkItemManager()).getWorkItem(id.longValue());
            if (workItem == null) {
                throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
            }
            WorkItem workItem2 = workItem;
            return workItem2;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public List<org.kie.api.runtime.process.WorkItem> getWorkItemByProcessInstance(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null || piDesc.getState() != 1) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        return this.getWorkItemByProcessInstance(piDesc.getDeploymentId(), processInstanceId);
    }

    public List<org.kie.api.runtime.process.WorkItem> getWorkItemByProcessInstance(String deploymentId, Long processInstanceId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            ArrayList<WorkItem> workItems = new ArrayList<WorkItem>();
            Collection nodes = this.dataService.getProcessInstanceHistoryActive(processInstanceId.longValue(), null);
            for (NodeInstanceDesc node : nodes) {
                if (node.getWorkItemId() == null) continue;
                workItems.add(((WorkItemManager)ksession.getWorkItemManager()).getWorkItem(node.getWorkItemId().longValue()));
            }
            ArrayList<WorkItem> arrayList = workItems;
            return arrayList;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public <T> T execute(String deploymentId, Command<T> command) {
        Long processInstanceId = CommonUtils.getProcessInstanceId(command);
        logger.debug("Executing command {} with process instance id {} as contextual data", command, (Object)processInstanceId);
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        this.disallowWhenNotActive(deployedUnit, command);
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession ksession = engine.getKieSession();
            Object object = ksession.execute(command);
            return (T)object;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public <T> T execute(String deploymentId, Context<?> context, Command<T> command) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        this.disallowWhenNotActive(deployedUnit, command);
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine(context);
        try {
            KieSession ksession = engine.getKieSession();
            Object object = ksession.execute(command);
            return (T)object;
        }
        catch (SessionNotFoundException e) {
            throw new ProcessInstanceNotFoundException("Process instance with context id " + context.getContextId() + " was not found", (Throwable)e);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    protected void disallowWhenNotActive(DeployedUnit deployedUnit, Command<?> cmd) {
        if (!deployedUnit.isActive() && cmd instanceof StartProcessCommand) {
            throw new DeploymentNotActiveException("Deployment " + deployedUnit.getDeploymentUnit().getIdentifier() + " is not active");
        }
    }

    protected Collection<String> collectActiveSignals(Collection<NodeInstance> activeNodes) {
        ArrayList<String> activeNodesComposite = new ArrayList<String>();
        for (NodeInstance nodeInstance : activeNodes) {
            String type;
            if (nodeInstance instanceof EventNodeInstance && (type = ((EventNodeInstance)nodeInstance).getEventNode().getType()) != null && !type.startsWith("Message-")) {
                activeNodesComposite.add(VariableUtil.resolveVariable((String)type, (NodeInstance)nodeInstance));
            }
            if (!(nodeInstance instanceof CompositeNodeInstance)) continue;
            Collection currentNodeInstances = ((CompositeNodeInstance)nodeInstance).getNodeInstances();
            activeNodesComposite.addAll(this.collectActiveSignals(currentNodeInstances));
        }
        return activeNodesComposite;
    }

    protected List<String> getActiveBoundaryNodesSignals(ProcessInstance processInstance, Collection<NodeInstance> activeNodes) {
        WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)processInstance;
        ArrayList<Node> processNodesList = new ArrayList<Node>(Arrays.asList(((RuleFlowProcessInstance)workflowProcessInstance).getNodeContainer().getNodes()));
        ArrayList<String> activeBoundaryNodesSignals = new ArrayList<String>();
        HashMap<String, NodeInstance> uniqueIdNodeInstanceMap = new HashMap<String, NodeInstance>();
        for (NodeInstance activeNode : activeNodes) {
            uniqueIdNodeInstanceMap.put((String)activeNode.getNode().getMetaData().get("UniqueId"), activeNode);
        }
        try {
            for (Node processNode : processNodesList) {
                if (!(processNode instanceof BoundaryEventNode) || !uniqueIdNodeInstanceMap.containsKey(((BoundaryEventNode)processNode).getAttachedToNodeId())) continue;
                activeBoundaryNodesSignals.add(VariableUtil.resolveVariable((String)((String)processNode.getMetaData().get("SignalName")), (NodeInstance)((NodeInstance)uniqueIdNodeInstanceMap.get(((BoundaryEventNode)processNode).getAttachedToNodeId()))));
            }
            return activeBoundaryNodesSignals;
        }
        catch (Exception e) {
            logger.debug("Unable to retrieve boundary event nodes for active nodes in processInstance {}", (Object)processInstance.getId());
            return new ArrayList<String>();
        }
    }

    @Override
    public <T> T process(T variables, ClassLoader cl) {
        return variables;
    }

    protected void disposeRuntimeEngine(RuntimeManager manager, RuntimeEngine engine) {
        manager.disposeRuntimeEngine(engine);
    }
}

