/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.dialect;

import org.dashbuilder.dataprovider.sql.dialect.DefaultDialect;
import org.dashbuilder.dataprovider.sql.model.Column;

public class MonetDBDialect
extends DefaultDialect {
    @Override
    public boolean allowAliasInStatements() {
        return true;
    }

    @Override
    public String getColumnTypeSQL(Column column) {
        switch (column.getType()) {
            case NUMBER: {
                return "NUMERIC(18,3)";
            }
            case DATE: {
                return "TIMESTAMP";
            }
        }
        return "VARCHAR(" + column.getLength() + ")";
    }

    @Override
    public String getAliasForColumnSQL(String alias) {
        return "AS \"" + alias + "\"";
    }

    @Override
    public String getAliasForStatementSQL(String alias) {
        return "\"" + alias + "\"";
    }

    @Override
    public String getColumnCastSQL(Column column) {
        String columnSQL = this.getColumnSQL(column);
        int length = column.getLength() < 10 ? 10 : column.getLength();
        return "CAST(" + columnSQL + " AS VARCHAR(" + length + "))";
    }
}

