/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling;

import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CustomStaxWriter
extends StaxWriter
implements AutoCloseable {
    private XMLStreamWriter out;
    private int tagDepth = 0;
    private Op lastOp = null;

    public CustomStaxWriter(QNameMap qnameMap, XMLStreamWriter out, boolean writeStartEndDocument, boolean repairingNamespace, NameCoder nameCoder) throws XMLStreamException {
        super(qnameMap, out, writeStartEndDocument, repairingNamespace, nameCoder);
        this.out = out;
    }

    public void writeNamespace(String prefix, String uri) throws XMLStreamException {
        if (!prefix.equals(this.out.getPrefix(uri))) {
            this.out.writeNamespace(prefix, uri);
        }
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.out.setDefaultNamespace(uri);
    }

    public void endNode() {
        if (this.lastOp == Op.END_NODE) {
            try {
                this.out.writeCharacters(System.lineSeparator());
                for (int i = 0; i < this.tagDepth - 1; ++i) {
                    this.out.writeCharacters("  ");
                }
            }
            catch (XMLStreamException e) {
                throw new StreamException((Throwable)e);
            }
        }
        super.endNode();
        --this.tagDepth;
        this.lastOp = Op.END_NODE;
        if (this.tagDepth == 0 && !this.out.getClass().getPackage().getName().startsWith("com.ctc.wstx")) {
            try {
                this.out.writeCharacters(System.lineSeparator());
            }
            catch (XMLStreamException e) {
                throw new StreamException((Throwable)e);
            }
        }
    }

    public void startNode(String arg0) {
        try {
            this.out.writeCharacters(System.lineSeparator());
            for (int i = 0; i < this.tagDepth; ++i) {
                this.out.writeCharacters("  ");
            }
        }
        catch (XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
        super.startNode(arg0);
        ++this.tagDepth;
        this.lastOp = Op.START_NODE;
    }

    public void setValue(String text) {
        super.setValue(text);
        this.lastOp = Op.VALUE;
    }

    public QNameMap getQNameMap() {
        return super.getQNameMap();
    }

    private static enum Op {
        START_NODE,
        END_NODE,
        VALUE;

    }
}

