/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.tx;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.time.JobContext;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionManagerHelper;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.timer.TimerManager;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class NoTransactionalTimerResourcesCleanupAwareSchedulerServiceInterceptor
extends DelegateSchedulerServiceInterceptor {
    private RuntimeEnvironment environment;
    private RuntimeManager manager;

    public NoTransactionalTimerResourcesCleanupAwareSchedulerServiceInterceptor(RuntimeEnvironment environment, RuntimeManager manager, GlobalSchedulerService schedulerService) {
        super(schedulerService);
        this.environment = environment;
        this.manager = manager;
    }

    public final void internalSchedule(TimerJobInstance timerJobInstance) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
            super.internalSchedule(timerJobInstance);
            return;
        }
        TransactionManager tm = this.getTransactionManager(timerJobInstance.getJobContext());
        List<Integer> invalidTxStatus = Arrays.asList(3, 1, 0);
        if (!invalidTxStatus.contains(tm.getStatus())) {
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new ScheduleTimerTransactionSynchronization(timerJobInstance));
        }
        super.internalSchedule(timerJobInstance);
    }

    protected boolean hasEnvironmentEntry(String name, Object value) {
        Object envEntry = this.environment.getEnvironment().get(name);
        if (value == null) {
            return envEntry == null;
        }
        return value.equals(envEntry);
    }

    protected TransactionManager getTransactionManager(JobContext jobContext) {
        Object txm = this.getEnvironment(jobContext).get("org.kie.transaction.TransactionManager");
        if (txm != null && txm instanceof TransactionManager) {
            return (TransactionManager)txm;
        }
        return TransactionManagerFactory.get().newTransactionManager();
    }

    protected Environment getEnvironment(JobContext jobContext) {
        JobContext ctxorig = jobContext;
        if (ctxorig instanceof SelfRemovalJobContext) {
            ctxorig = ((SelfRemovalJobContext)ctxorig).getJobContext();
        }
        if (ctxorig instanceof TimerManager.ProcessJobContext) {
            return ((TimerManager.ProcessJobContext)ctxorig).getKnowledgeRuntime().getEnvironment();
        }
        if (this.manager != null) {
            RuntimeEngine engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)this.getProcessInstancId(ctxorig)));
            return engine.getKieSession().getEnvironment();
        }
        return this.environment.getEnvironment();
    }

    protected Long getProcessInstancId(JobContext jobContext) {
        if (jobContext instanceof TimerManager.ProcessJobContext) {
            return ((TimerManager.ProcessJobContext)jobContext).getProcessInstanceId();
        }
        if (jobContext instanceof NamedJobContext) {
            return ((NamedJobContext)jobContext).getProcessInstanceId();
        }
        return null;
    }

    private class ScheduleTimerTransactionSynchronization
    extends OrderedTransactionSynchronization {
        private TimerJobInstance timerJobInstance;

        public ScheduleTimerTransactionSynchronization(TimerJobInstance timerJobInstance) {
            super(Integer.valueOf(5), "NoTransactionalTimerResourcesCleanupAwareSchedulerServiceInterceptor");
            this.timerJobInstance = timerJobInstance;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 1) {
                JobContext ctxorig = this.timerJobInstance.getJobContext();
                JobContext jobContext = ctxorig = ctxorig instanceof SelfRemovalJobContext ? ((SelfRemovalJobContext)ctxorig).getJobContext() : ctxorig;
                if (!(ctxorig instanceof TimerManager.ProcessJobContext)) {
                    return;
                }
                Optional runtime = ctxorig.getInternalKnowledgeRuntime();
                if (runtime.isPresent()) {
                    TimerManager tm = ((InternalProcessRuntime)((InternalKnowledgeRuntime)runtime.get()).getProcessRuntime()).getTimerManager();
                    tm.cancelTimer(((TimerManager.ProcessJobContext)ctxorig).getTimer().getId());
                }
            }
        }

        public int compareTo(OrderedTransactionSynchronization o) {
            if (o instanceof ScheduleTimerTransactionSynchronization) {
                if (this.timerJobInstance.equals(((ScheduleTimerTransactionSynchronization)o).timerJobInstance)) {
                    return 0;
                }
                return -1;
            }
            return super.compareTo(o);
        }
    }
}

