/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.Version;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.TestPersistenceContextBase;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.jbpm.test.persistence.scripts.util.TestsUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptsBase {
    protected static final String DB_DDL_SCRIPTS_RESOURCE_PATH = "/db/ddl-scripts";
    protected static final String TEST_PROCESS_ID = "minimalProcess";
    protected static final String PERSISTENCE_XML_PATH = "target/test-classes/META-INF/persistence.xml";
    protected static final String BACKUP_PERSISTENCE_XML_PATH = "target/test-classes/META-INF/persistence-backup.xml";
    private static final Logger logger = LoggerFactory.getLogger(ScriptsBase.class);
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            logger.info(">>>> Starting test: " + description.getMethodName());
        }
    };

    @BeforeClass
    public static void cleanUp() throws IOException, SQLException {
        logger.info("Running with Hibernate " + Version.getVersionString());
        TestsUtil.clearSchema();
        ScriptsBase.executeScriptRunner(DB_DDL_SCRIPTS_RESOURCE_PATH, ScriptFilter.init(false, false));
        ScriptsBase.executeScriptRunner(DB_DDL_SCRIPTS_RESOURCE_PATH, ScriptFilter.filter("task_assigning_tables_drop_"));
    }

    @Before
    public void setUp() throws IOException {
        Files.copy(Paths.get(PERSISTENCE_XML_PATH, new String[0]), Paths.get(BACKUP_PERSISTENCE_XML_PATH, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    @After
    public void restoreBackup() throws IOException {
        Files.copy(Paths.get(BACKUP_PERSISTENCE_XML_PATH, new String[0]), Paths.get(PERSISTENCE_XML_PATH, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void executeScriptRunner(String resourcePath, ScriptFilter scriptFilter) throws IOException, SQLException {
        TestPersistenceContextBase scriptRunnerContext = TestPersistenceContextBase.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.executeScripts(new File(ScriptsBase.class.getResource(resourcePath).getFile()), scriptFilter);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeScriptRunner(String resourcePath, ScriptFilter scriptFilter, DataSource dataSource, String defaultSchema) throws IOException, SQLException {
        TestPersistenceContextBase scriptRunnerContext = new TestPersistenceContextBase();
        try {
            scriptRunnerContext.executeScripts(new File(ScriptsBase.class.getResource(resourcePath).getFile()), scriptFilter, dataSource, defaultSchema);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }

    protected void replaceNewGeneratorMappingsValue(ScriptFilter script) throws IOException {
        if (script.hasOption(ScriptFilter.Option.NEW_GENERATOR_MAPPINGS_TRUE)) {
            Files.write(Paths.get(PERSISTENCE_XML_PATH, new String[0]), this.getUpdatedXml("true").getBytes(), new OpenOption[0]);
        } else {
            Files.write(Paths.get(PERSISTENCE_XML_PATH, new String[0]), this.getUpdatedXml("false").getBytes(), new OpenOption[0]);
        }
    }

    protected String getUpdatedXml(String placeholderValue) throws IOException {
        String templateXml = new String(Files.readAllBytes(Paths.get(BACKUP_PERSISTENCE_XML_PATH, new String[0])));
        return templateXml.replace("${new_generator_mappings.value}", placeholderValue);
    }
}

