/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kproject.KieModuleException;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.RuleTemplateModelImpl;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.RuleTemplateModel;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.conf.SessionsPoolOption;
import org.kie.api.io.ResourceType;

public class KieBaseModelImpl
implements KieBaseModel {
    private String name;
    private Set<String> includes = new HashSet<String>();
    private List<String> packages;
    private EqualityBehaviorOption equalsBehavior = EqualityBehaviorOption.IDENTITY;
    private KieBaseMutabilityOption mutability = KieBaseMutabilityOption.ALLOWED;
    private EventProcessingOption eventProcessingMode = EventProcessingOption.CLOUD;
    private DeclarativeAgendaOption declarativeAgenda = DeclarativeAgendaOption.DISABLED;
    private SequentialOption sequential = SequentialOption.NO;
    private SessionsPoolOption sessionsPool = SessionsPoolOption.NO;
    private BetaRangeIndexOption betaRangeIndexOption = BetaRangeIndexOption.DISABLED;
    private Map<String, KieSessionModel> kSessions = new HashMap<String, KieSessionModel>();
    private KieModuleModel kModule;
    private String scope = "javax.enterprise.context.ApplicationScoped";
    private List<RuleTemplateModel> ruleTemplates = new ArrayList<RuleTemplateModel>();
    private boolean isDefault = false;

    public KieBaseModelImpl() {
    }

    public KieBaseModelImpl(KieModuleModel kModule, String name) {
        this.kModule = kModule;
        this.includes = new HashSet<String>();
        this.name = name;
        this.kSessions = Collections.emptyMap();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public KieBaseModel setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public List<String> getPackages() {
        return this.packages != null ? this.packages : Collections.emptyList();
    }

    public KieBaseModel addPackage(String pkg) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(pkg);
        return this;
    }

    public KieBaseModel removePackage(String pkg) {
        if (this.packages != null) {
            this.packages.remove(pkg);
        }
        return this;
    }

    public KieModuleModel getKModule() {
        return this.kModule;
    }

    public void setKModule(KieModuleModel kieProject) {
        this.kModule = kieProject;
    }

    public Map<String, KieSessionModel> getKieSessionModels() {
        return Collections.unmodifiableMap(this.kSessions);
    }

    public Map<String, KieSessionModel> getRawKieSessionModels() {
        return this.kSessions;
    }

    private void setKSessions(Map<String, KieSessionModel> kSessions) {
        this.kSessions = kSessions;
    }

    public KieSessionModel newKieSessionModel(String name) {
        KieSessionModelImpl kieSessionModel = new KieSessionModelImpl(this, name);
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        newMap.put(kieSessionModel.getName(), kieSessionModel);
        this.setKSessions(newMap);
        return kieSessionModel;
    }

    public KieBaseModel removeKieSessionModel(String qName) {
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        newMap.remove(qName);
        this.setKSessions(newMap);
        return this;
    }

    public void moveKSession(String oldQName, String newQName) {
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        KieSessionModel kieSessionModel = (KieSessionModel)newMap.remove(oldQName);
        newMap.put(newQName, kieSessionModel);
        this.setKSessions(newMap);
    }

    public List<RuleTemplateModel> getRuleTemplates() {
        return Collections.unmodifiableList(this.ruleTemplates);
    }

    public List<RuleTemplateModel> getRawRuleTemplates() {
        return this.ruleTemplates;
    }

    public KieBaseModel addRuleTemplate(String dtable, String template, int row, int col) {
        this.ruleTemplates.add(new RuleTemplateModelImpl(this, dtable, template, row, col));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KieBaseModel setName(String name) {
        ((KieModuleModelImpl)this.kModule).changeKBaseName(this, this.name, name);
        this.name = name;
        return this;
    }

    void changeKSessionName(KieSessionModel kieSession, String oldName, String newName) {
        this.kSessions.remove(oldName);
        this.kSessions.put(newName, kieSession);
    }

    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public KieBaseModel addInclude(String kBaseQName) {
        this.includes.add(kBaseQName);
        return this;
    }

    public KieBaseModel removeInclude(String kBaseQName) {
        this.includes.remove(kBaseQName);
        return this;
    }

    public SessionsPoolOption getSessionsPool() {
        return this.sessionsPool;
    }

    public KieBaseModel setSessionsPool(SessionsPoolOption sessionsPool) {
        this.sessionsPool = sessionsPool;
        return this;
    }

    public EqualityBehaviorOption getEqualsBehavior() {
        return this.equalsBehavior;
    }

    public KieBaseModel setEqualsBehavior(EqualityBehaviorOption equalsBehaviour) {
        this.equalsBehavior = equalsBehaviour;
        return this;
    }

    public KieBaseMutabilityOption getMutability() {
        return this.mutability;
    }

    public KieBaseModel setMutability(KieBaseMutabilityOption mutability) {
        this.mutability = mutability;
        return this;
    }

    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    public KieBaseModel setEventProcessingMode(EventProcessingOption eventProcessingMode) {
        this.eventProcessingMode = eventProcessingMode;
        return this;
    }

    public DeclarativeAgendaOption getDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    public KieBaseModel setDeclarativeAgenda(DeclarativeAgendaOption declarativeAgenda) {
        this.declarativeAgenda = declarativeAgenda;
        return this;
    }

    public BetaRangeIndexOption getBetaRangeIndexOption() {
        return this.betaRangeIndexOption;
    }

    public KieBaseModel setBetaRangeIndexOption(BetaRangeIndexOption betaRangeIndexOption) {
        this.betaRangeIndexOption = betaRangeIndexOption;
        return this;
    }

    public SequentialOption getSequential() {
        return this.sequential;
    }

    public KieBaseModel setSequential(SequentialOption sequential) {
        this.sequential = sequential;
        return this;
    }

    public KieBaseModel setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public static List<String> getFiles(String kBaseName, ZipFile zipFile) {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!KieBaseModelImpl.filterFileInKBase(kBaseName.replace('.', '/'), fileName)) continue;
            files.add(fileName);
        }
        return files;
    }

    public static List<String> getFiles(File rootFolder) {
        return IoUtils.recursiveListFile((File)rootFolder, (String)"", file -> {
            String fileName = file.getName();
            return fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.GDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.RDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension()) || fileName.endsWith(ResourceType.TDRL.getDefaultExtension());
        });
    }

    private static boolean filterFileInKBase(String rootPath, String fileName) {
        return fileName.startsWith(rootPath) && (fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.GDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.RDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension()) || fileName.endsWith(ResourceType.TDRL.getDefaultExtension()));
    }

    public String toString() {
        return "KieBaseModelImpl [name=" + this.name + ", includes=" + this.includes + ", packages=" + this.getPackages() + ", equalsBehavior=" + this.equalsBehavior + ", mutability=" + this.mutability + ", eventProcessingMode=" + this.eventProcessingMode + ", kSessions=" + this.kSessions + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KieBaseModelImpl that = (KieBaseModelImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class KBaseConverter
    extends AbstractXStreamConverter {
        public KBaseConverter() {
            super(KieBaseModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieBaseModelImpl kBase = (KieBaseModelImpl)value;
            writer.addAttribute("name", kBase.getName());
            writer.addAttribute("default", Boolean.toString(kBase.isDefault()));
            if (kBase.getEventProcessingMode() != null) {
                writer.addAttribute("eventProcessingMode", kBase.getEventProcessingMode().getMode());
            }
            if (kBase.getEqualsBehavior() != null) {
                writer.addAttribute("equalsBehavior", kBase.getEqualsBehavior().toString().toLowerCase());
            }
            if (kBase.getMutability() != null) {
                writer.addAttribute("mutability", kBase.getMutability().toString().toLowerCase());
            }
            if (kBase.getDeclarativeAgenda() != null) {
                writer.addAttribute("declarativeAgenda", kBase.getDeclarativeAgenda().toString().toLowerCase());
            }
            if (kBase.getSequential() != null) {
                writer.addAttribute("sequential", kBase.getSequential() == SequentialOption.YES ? "true" : "false");
            }
            if (kBase.getSessionsPool() != null) {
                writer.addAttribute("sessionsPool", "" + kBase.getSessionsPool().getSize());
            }
            if (kBase.getBetaRangeIndexOption() != null) {
                writer.addAttribute("betaRangeIndex", kBase.getBetaRangeIndexOption().toString().toLowerCase());
            }
            if (kBase.getScope() != null) {
                writer.addAttribute("scope", kBase.getScope());
            }
            if (!kBase.getPackages().isEmpty()) {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (String pkg : kBase.getPackages()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(pkg);
                }
                writer.addAttribute("packages", buf.toString());
            }
            if (!kBase.getIncludes().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                boolean insertComma = false;
                for (String include : kBase.getIncludes()) {
                    if (insertComma) {
                        sb.append(", ");
                    }
                    sb.append(include);
                    if (insertComma) continue;
                    insertComma = true;
                }
                writer.addAttribute("includes", sb.toString());
            }
            for (RuleTemplateModel ruleTemplateModel : kBase.getRuleTemplates()) {
                this.writeObject(writer, context, "ruleTemplate", ruleTemplateModel);
            }
            for (KieSessionModel kSessionModel : kBase.getKieSessionModels().values()) {
                this.writeObject(writer, context, "ksession", kSessionModel);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            String includes;
            String pkgs;
            String scope;
            String betaRangeIndex;
            String sessionsPool;
            String sequential;
            String declarativeAgenda;
            String mutability;
            String equalsBehavior;
            final KieBaseModelImpl kBase = new KieBaseModelImpl();
            String kbaseName = reader.getAttribute("name");
            kBase.name = kbaseName != null ? kbaseName : StringUtils.uuid();
            if (kBase.name.isEmpty()) {
                throw new KieModuleException("kbase name is empty in kmodule.xml");
            }
            kBase.setDefault("true".equals(reader.getAttribute("default")));
            String eventMode = reader.getAttribute("eventProcessingMode");
            if (eventMode != null) {
                kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventMode));
            }
            if ((equalsBehavior = reader.getAttribute("equalsBehavior")) != null) {
                kBase.setEqualsBehavior(EqualityBehaviorOption.determineEqualityBehavior((String)equalsBehavior));
            }
            if ((mutability = reader.getAttribute("mutability")) != null) {
                kBase.setMutability(KieBaseMutabilityOption.determineMutability((String)mutability));
            }
            if ((declarativeAgenda = reader.getAttribute("declarativeAgenda")) != null) {
                kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgenda((String)declarativeAgenda));
            }
            if ((sequential = reader.getAttribute("sequential")) != null) {
                kBase.setSequential(SequentialOption.determineSequential((String)sequential));
            }
            if ((sessionsPool = reader.getAttribute("sessionsPool")) != null) {
                kBase.setSessionsPool(SessionsPoolOption.get((int)Integer.parseInt(sessionsPool)));
            }
            if ((betaRangeIndex = reader.getAttribute("betaRangeIndex")) != null) {
                kBase.setBetaRangeIndexOption(BetaRangeIndexOption.determineBetaRangeIndex((String)betaRangeIndex));
            }
            if ((scope = reader.getAttribute("scope")) != null) {
                kBase.setScope(scope.trim());
            }
            if ((pkgs = reader.getAttribute("packages")) != null) {
                for (String pkg : pkgs.split(",")) {
                    kBase.addPackage(pkg.trim());
                }
            }
            if ((includes = reader.getAttribute("includes")) != null) {
                for (String include : includes.split(",")) {
                    kBase.addInclude(include.trim());
                }
            }
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("ksession".equals(name)) {
                        KieSessionModelImpl kSession = (KieSessionModelImpl)this.readObject(reader, context, KieSessionModelImpl.class);
                        kBase.getRawKieSessionModels().put(kSession.getName(), kSession);
                        kSession.setKBase(kBase);
                    } else if ("ruleTemplate".equals(name)) {
                        RuleTemplateModelImpl ruleTemplate = (RuleTemplateModelImpl)this.readObject(reader, context, RuleTemplateModelImpl.class);
                        kBase.getRawRuleTemplates().add(ruleTemplate);
                        ruleTemplate.setKBase(kBase);
                    }
                }
            });
            return kBase;
        }
    }
}

