/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakAsyncSendNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.Sink;
import org.drools.core.rule.ContextEntry;
import org.drools.core.util.index.TupleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhreakAsyncReceiveNode {
    private static final Logger log = LoggerFactory.getLogger(PhreakAsyncReceiveNode.class);

    public void doNode(AsyncReceiveNode node, AsyncReceiveNode.AsyncReceiveMemory memory, LeftTupleSink sink, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(memory, srcLeftTuples);
        }
        PhreakAsyncReceiveNode.doPropagateChildLeftTuples(node, memory, wm, sink, trgLeftTuples);
        srcLeftTuples.resetAll();
    }

    private void doLeftInserts(AsyncReceiveNode.AsyncReceiveMemory memory, TupleSets<LeftTuple> srcLeftTuples) {
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            memory.addInsertOrUpdateLeftTuple(leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private static void doPropagateChildLeftTuples(AsyncReceiveNode node, AsyncReceiveNode.AsyncReceiveMemory memory, InternalWorkingMemory wm, LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples) {
        BetaConstraints betaConstraints = node.getBetaConstraints();
        ContextEntry[] context = betaConstraints.createContext();
        TupleList leftTuples = memory.getInsertOrUpdateLeftTuples();
        for (LeftTuple leftTuple = (LeftTuple)leftTuples.getFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getNext()) {
            betaConstraints.updateFromTuple(context, wm, leftTuple);
            for (Object message : memory.getMessages()) {
                InternalFactHandle factHandle = wm.getFactHandleFactory().newFactHandle(message, node.getObjectTypeConf(wm), wm, null);
                if (!PhreakAsyncSendNode.isAllowed(factHandle, node.getAlphaConstraints(), wm) || !betaConstraints.isAllowedCachedLeft(context, factHandle)) continue;
                LeftTuple childLeftTuple = sink.createLeftTuple(factHandle, leftTuple, (Sink)sink);
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                trgLeftTuples.addInsert(childLeftTuple);
            }
        }
        memory.reset();
    }
}

