/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Salience;
import org.drools.core.spi.Tuple;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;

public class PhreakRuleTerminalNode {
    public void doNode(TerminalNode rtnNode, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(agenda, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(rtnNode, agenda, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(rtnNode, agenda, srcLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TerminalNode rtnNode, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            agenda.setFocus(ruleAgendaItem.getAgendaGroup());
        }
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleInsert(rtnNode, executor, agenda, ruleAgendaItem, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleInsert(TerminalNode rtnNode, RuleExecutor executor, InternalAgenda agenda, RuleAgendaItem ruleAgendaItem, LeftTuple leftTuple) {
        InternalWorkingMemory wm = agenda.getWorkingMemory();
        if (wm.getSessionConfiguration().isDirectFiring()) {
            executor.addLeftTuple(leftTuple);
            return;
        }
        PropagationContext pctx = leftTuple.findMostRecentPropagationContext();
        if (rtnNode.getRule().isNoLoop() && rtnNode.equals(pctx.getTerminalNodeOrigin())) {
            return;
        }
        int salienceInt = PhreakRuleTerminalNode.getSalienceValue(rtnNode, ruleAgendaItem, AgendaItem.getAgendaItem(leftTuple), wm);
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        agenda.createAgendaItem(rtnLeftTuple, salienceInt, pctx, ruleAgendaItem, ruleAgendaItem.getAgendaGroup());
        InternalWorkingMemory es = wm;
        es.getAgendaEventSupport().fireActivationCreated(rtnLeftTuple, wm);
        if (rtnNode.getRule().isLockOnActive() && leftTuple.getPropagationContext().getType() != PropagationContext.Type.RULE_ADDITION) {
            InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
            if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, agendaGroup)) {
                es.getAgendaEventSupport().fireActivationCancelled(rtnLeftTuple, wm, MatchCancelledCause.FILTER);
                return;
            }
        }
        if (agenda.getActivationsFilter() != null && !agenda.getActivationsFilter().accept(rtnLeftTuple, wm, rtnNode)) {
            return;
        }
        agenda.addItemToActivationGroup(rtnLeftTuple);
        executor.addLeftTuple(leftTuple);
        leftTuple.increaseActivationCountForEvents();
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            agenda.insertAndStageActivation(rtnLeftTuple);
        }
    }

    private static int getSalienceValue(TerminalNode rtnNode, RuleAgendaItem ruleAgendaItem, AgendaItem leftTuple, InternalWorkingMemory wm) {
        Salience salience = ruleAgendaItem.getRule().getSalience();
        return salience == null ? 0 : (salience.isDynamic() ? salience.getValue(wm.createKnowledgeHelper(leftTuple), (Rule)rtnNode.getRule(), wm) : salience.getValue());
    }

    public void doLeftUpdates(TerminalNode rtnNode, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            agenda.setFocus(ruleAgendaItem.getAgendaGroup());
        }
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleUpdate(rtnNode, executor, agenda, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleUpdate(TerminalNode rtnNode, RuleExecutor executor, InternalAgenda agenda, LeftTuple leftTuple) {
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        InternalWorkingMemory wm = agenda.getWorkingMemory();
        if (wm.getSessionConfiguration().isDirectFiring()) {
            if (!rtnLeftTuple.isQueued()) {
                executor.addLeftTuple(leftTuple);
                wm.getRuleEventSupport().onUpdateMatch(rtnLeftTuple);
            }
            return;
        }
        PropagationContext pctx = leftTuple.findMostRecentPropagationContext();
        boolean blocked = false;
        if (executor.isDeclarativeAgendaEnabled()) {
            if (rtnLeftTuple.getBlockers() != null && !rtnLeftTuple.getBlockers().isEmpty()) {
                blocked = true;
            }
        } else {
            blocked = rtnNode.getRule().isNoLoop() && rtnNode.equals(pctx.getTerminalNodeOrigin());
        }
        int salienceInt = PhreakRuleTerminalNode.getSalienceValue(rtnNode, executor.getRuleAgendaItem(), (AgendaItem)((Object)leftTuple), wm);
        if (agenda.getActivationsFilter() != null && !agenda.getActivationsFilter().accept(rtnLeftTuple, wm, rtnNode)) {
            return;
        }
        if (!blocked) {
            boolean addToExector = true;
            if (rtnNode.getRule().isLockOnActive() && pctx.getType() != PropagationContext.Type.RULE_ADDITION) {
                InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
                if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, agendaGroup)) {
                    addToExector = false;
                }
            }
            if (addToExector && !rtnLeftTuple.isQueued()) {
                InternalWorkingMemory es = wm;
                es.getAgendaEventSupport().fireActivationCreated(rtnLeftTuple, wm);
                rtnLeftTuple.update(salienceInt, pctx);
                executor.addLeftTuple(leftTuple);
                wm.getRuleEventSupport().onUpdateMatch(rtnLeftTuple);
            }
        } else {
            rtnLeftTuple.update(salienceInt, pctx);
        }
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            agenda.modifyActivation(rtnLeftTuple, rtnLeftTuple.isQueued());
        }
    }

    public void doLeftDeletes(InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftDelete(agenda, executor, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftDelete(InternalAgenda agenda, RuleExecutor executor, Tuple leftTuple) {
        RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)leftTuple;
        rtnLt.setMatched(false);
        agenda.cancelActivation(rtnLt);
        if (leftTuple.getMemory() != null) {
            executor.removeLeftTuple(leftTuple);
        }
        leftTuple.setContextObject(null);
    }

    private static boolean blockedByLockOnActive(RuleImpl rule, PropagationContext pctx, InternalAgendaGroup agendaGroup) {
        if (rule.isLockOnActive()) {
            long handleRecency = pctx.getFactHandle().getRecency();
            boolean isActive = agendaGroup.isActive();
            long activatedForRecency = agendaGroup.getActivatedForRecency();
            long clearedForRecency = agendaGroup.getClearedForRecency();
            if (isActive && activatedForRecency < handleRecency && agendaGroup.getAutoFocusActivator() != pctx) {
                return true;
            }
            return clearedForRecency != -1L && clearedForRecency >= handleRecency;
        }
        return false;
    }
}

