/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.util.ArrayList;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ValueType;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.TupleValueExtractor;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleIndexRBTree;
import org.drools.core.util.index.TupleList;
import org.kie.internal.conf.IndexPrecedenceOption;

public class IndexUtil {
    static boolean USE_COMPARISON_INDEX = true;
    static boolean USE_COMPARISON_INDEX_JOIN = true;

    public static boolean compositeAllowed(BetaNodeFieldConstraint[] constraints, short betaNodeType, RuleBaseConfiguration config) {
        int firstUnification = -1;
        int firstNonUnification = -1;
        int length = constraints.length;
        for (int i = 0; i < length; ++i) {
            if (IndexUtil.isIndexable(constraints[i], betaNodeType, config)) {
                boolean isUnification = ((IndexableConstraint)((Object)constraints[i])).isUnification();
                if (isUnification && firstUnification == -1) {
                    firstUnification = i;
                } else if (!isUnification && firstNonUnification == -1) {
                    firstNonUnification = i;
                }
            }
            if (firstUnification != -1 && firstNonUnification != -1) break;
        }
        if (firstNonUnification > 0) {
            IndexUtil.swap(constraints, 0, firstNonUnification);
        }
        return firstUnification == -1;
    }

    public static boolean isIndexable(BetaNodeFieldConstraint constraint, short nodeType, RuleBaseConfiguration config) {
        return constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).isIndexable(nodeType, config) && !IndexUtil.isBigDecimalEqualityConstraint((IndexableConstraint)((Object)constraint));
    }

    private static boolean canHaveRangeIndex(short nodeType, IndexableConstraint constraint, RuleBaseConfiguration config) {
        return IndexUtil.canHaveRangeIndexForNodeType(nodeType, config) && IndexUtil.areRangeIndexCompatibleOperands(constraint);
    }

    private static boolean canHaveRangeIndexForNodeType(short nodeType, RuleBaseConfiguration config) {
        if (USE_COMPARISON_INDEX_JOIN && config.isBetaNodeRangeIndexEnabled()) {
            return USE_COMPARISON_INDEX && (nodeType == 191 || nodeType == 201 || nodeType == 181);
        }
        return USE_COMPARISON_INDEX && (nodeType == 191 || nodeType == 201);
    }

    private static boolean areRangeIndexCompatibleOperands(IndexableConstraint constraint) {
        InternalReadAccessor fieldExtractor = null;
        TupleValueExtractor indexingDeclaration = null;
        try {
            fieldExtractor = constraint.getFieldExtractor();
            indexingDeclaration = constraint.getIndexExtractor();
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
        if (fieldExtractor == null || indexingDeclaration == null) {
            return false;
        }
        ValueType leftValueType = fieldExtractor.getValueType();
        ValueType rightValueType = indexingDeclaration.getValueType();
        if (leftValueType != null && rightValueType != null) {
            if (leftValueType.isNumber() && rightValueType.isNumber()) {
                return true;
            }
            Class<?> leftClass = leftValueType.getClassType();
            Class<?> rightClass = rightValueType.getClassType();
            if (leftClass != null && rightClass != null && Comparable.class.isAssignableFrom(leftClass) && leftClass.equals(rightClass)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isIndexableForNode(short nodeType, BetaNodeFieldConstraint constraint, RuleBaseConfiguration config) {
        if (!(constraint instanceof IndexableConstraint)) {
            return false;
        }
        ConstraintType constraintType = ((IndexableConstraint)((Object)constraint)).getConstraintType();
        if (IndexUtil.isBigDecimalEqualityConstraint((IndexableConstraint)((Object)constraint))) {
            return false;
        }
        return constraintType.isIndexableForNode(nodeType, (IndexableConstraint)((Object)constraint), config);
    }

    public static boolean isBigDecimalEqualityConstraint(IndexableConstraint indexableConstraint) {
        return indexableConstraint.getConstraintType() == ConstraintType.EQUAL && indexableConstraint.getFieldExtractor() != null && indexableConstraint.getFieldExtractor().getValueType() == ValueType.BIG_DECIMAL_TYPE;
    }

    public static boolean[] isIndexableForNode(IndexPrecedenceOption indexPrecedenceOption, short nodeType, int keyDepth, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        if (keyDepth < 1) {
            return new boolean[constraints.length];
        }
        return indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? IndexUtil.findIndexableWithEqualityPriority(nodeType, keyDepth, constraints, config) : IndexUtil.findIndexableWithPatternOrder(nodeType, keyDepth, constraints, config);
    }

    private static boolean[] findIndexableWithEqualityPriority(short nodeType, int keyDepth, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        boolean[] indexable = new boolean[constraints.length];
        if (IndexUtil.hasEqualIndexable(keyDepth, indexable, constraints)) {
            return indexable;
        }
        if (!IndexUtil.canHaveRangeIndexForNodeType(nodeType, config)) {
            return indexable;
        }
        for (int i = 0; i < constraints.length; ++i) {
            if (!IndexUtil.isIndexable(constraints[i], nodeType, config)) continue;
            IndexUtil.sortRangeIndexable(constraints, indexable, i);
            break;
        }
        return indexable;
    }

    private static boolean[] findIndexableWithPatternOrder(short nodeType, int keyDepth, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        boolean[] indexable = new boolean[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            if (!IndexUtil.isIndexable(constraints[i], nodeType, config)) continue;
            if (IndexUtil.isEqualIndexable(constraints[i])) {
                IndexUtil.sortEqualIndexable(keyDepth, indexable, constraints, i);
                break;
            }
            IndexUtil.sortRangeIndexable(constraints, indexable, i);
            break;
        }
        return indexable;
    }

    private static boolean hasEqualIndexable(int keyDepth, boolean[] indexable, BetaNodeFieldConstraint[] constraints) {
        return IndexUtil.sortEqualIndexable(keyDepth, indexable, constraints, 0);
    }

    private static boolean sortEqualIndexable(int keyDepth, boolean[] indexable, BetaNodeFieldConstraint[] constraints, int start) {
        boolean hasEqualIndexable = false;
        int indexableCouter = 0;
        for (int i = start; i < constraints.length; ++i) {
            if (!IndexUtil.isEqualIndexable(constraints[i])) continue;
            hasEqualIndexable = true;
            if (keyDepth <= indexableCouter) continue;
            IndexUtil.swap(constraints, i, indexableCouter);
            indexable[indexableCouter++] = true;
        }
        return hasEqualIndexable;
    }

    private static void sortRangeIndexable(BetaNodeFieldConstraint[] constraints, boolean[] indexable, int i) {
        IndexUtil.swap(constraints, i, 0);
        indexable[0] = true;
    }

    static boolean isEqualIndexable(BetaNodeFieldConstraint constraint) {
        return constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).getConstraintType() == ConstraintType.EQUAL && !IndexUtil.isBigDecimalEqualityConstraint((IndexableConstraint)((Object)constraint));
    }

    private static void swap(BetaNodeFieldConstraint[] constraints, int p1, int p2) {
        if (p1 != p2) {
            BetaNodeFieldConstraint temp = constraints[p2];
            constraints[p2] = constraints[p1];
            constraints[p1] = temp;
        }
    }

    public static class Factory {
        public static BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType, BetaNodeFieldConstraint ... constraints) {
            if (config.getCompositeKeyDepth() < 1) {
                return new BetaMemory(config.isSequential() ? null : new TupleList(), new TupleList(), Factory.createContext(constraints), nodeType);
            }
            IndexSpec indexSpec = new IndexSpec(nodeType, constraints, config);
            return new BetaMemory(Factory.createLeftMemory(config, indexSpec), Factory.createRightMemory(config, indexSpec), Factory.createContext(constraints), nodeType);
        }

        private static TupleMemory createRightMemory(RuleBaseConfiguration config, IndexSpec indexSpec) {
            if (!config.isIndexRightBetaMemory() || !indexSpec.constraintType.isIndexable() || indexSpec.indexes.length == 0) {
                return new TupleList();
            }
            if (indexSpec.constraintType == ConstraintType.EQUAL) {
                return new TupleIndexHashTable(indexSpec.indexes, false);
            }
            if (indexSpec.constraintType.isComparison()) {
                return new TupleIndexRBTree(indexSpec.constraintType, indexSpec.indexes[0], false);
            }
            return new TupleList();
        }

        private static TupleMemory createLeftMemory(RuleBaseConfiguration config, IndexSpec indexSpec) {
            if (config.isSequential()) {
                return null;
            }
            if (!config.isIndexLeftBetaMemory() || !indexSpec.constraintType.isIndexable() || indexSpec.indexes.length == 0) {
                return new TupleList();
            }
            if (indexSpec.constraintType == ConstraintType.EQUAL) {
                return new TupleIndexHashTable(indexSpec.indexes, true);
            }
            if (indexSpec.constraintType.isComparison()) {
                return new TupleIndexRBTree(indexSpec.constraintType, indexSpec.indexes[0], true);
            }
            return new TupleList();
        }

        public static ContextEntry[] createContext(BetaNodeFieldConstraint ... constraints) {
            ContextEntry[] entries = new ContextEntry[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                entries[i] = constraints[i].createContextEntry();
            }
            return entries;
        }

        private static class IndexSpec {
            private ConstraintType constraintType = ConstraintType.UNKNOWN;
            private AbstractHashTable.FieldIndex[] indexes;

            private IndexSpec(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
                this.init(nodeType, constraints, config);
            }

            private void init(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
                int firstIndexableConstraint;
                int keyDepth = config.getCompositeKeyDepth();
                IndexPrecedenceOption indexPrecedenceOption = config.getIndexPrecedenceOption();
                int n = firstIndexableConstraint = indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? this.determineTypeWithEqualityPriority(nodeType, constraints, config) : this.determineTypeWithPatternOrder(nodeType, constraints, config);
                if (this.constraintType == ConstraintType.EQUAL) {
                    ArrayList<AbstractHashTable.FieldIndex> indexList = new ArrayList<AbstractHashTable.FieldIndex>();
                    if (IndexUtil.isEqualIndexable(constraints[firstIndexableConstraint])) {
                        indexList.add(((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex());
                    }
                    for (int i = firstIndexableConstraint + 1; i < constraints.length && indexList.size() < keyDepth; ++i) {
                        if (!IndexUtil.isEqualIndexable(constraints[i]) || ((IndexableConstraint)((Object)constraints[i])).isUnification()) continue;
                        indexList.add(((IndexableConstraint)((Object)constraints[i])).getFieldIndex());
                    }
                    this.indexes = indexList.toArray(new AbstractHashTable.FieldIndex[indexList.size()]);
                } else if (this.constraintType.isComparison()) {
                    this.indexes = new AbstractHashTable.FieldIndex[]{((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex()};
                }
            }

            private int determineTypeWithEqualityPriority(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
                int indexedConstraintPos = 0;
                for (int i = 0; i < constraints.length; ++i) {
                    if (!(constraints[i] instanceof IndexableConstraint)) continue;
                    IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)constraints[i]);
                    ConstraintType type = indexableConstraint.getConstraintType();
                    if (type == ConstraintType.EQUAL) {
                        this.constraintType = type;
                        return i;
                    }
                    if (this.constraintType != ConstraintType.UNKNOWN || !type.isIndexableForNode(nodeType, indexableConstraint, config)) continue;
                    this.constraintType = type;
                    indexedConstraintPos = i;
                }
                return indexedConstraintPos;
            }

            private int determineTypeWithPatternOrder(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
                for (int i = 0; i < constraints.length; ++i) {
                    ConstraintType type = ConstraintType.getType(constraints[i]);
                    if (!type.isIndexableForNode(nodeType, (IndexableConstraint)((Object)constraints[i]), config)) continue;
                    this.constraintType = type;
                    return i;
                }
                return constraints.length;
            }
        }
    }

    public static enum ConstraintType {
        EQUAL(true, "=="),
        NOT_EQUAL(false, "!="),
        GREATER_THAN(true, ">"),
        GREATER_OR_EQUAL(true, ">="),
        LESS_THAN(true, "<"),
        LESS_OR_EQUAL(true, "<="),
        RANGE(true, null),
        UNKNOWN(false, null);

        private final boolean indexable;
        private final String operator;

        private ConstraintType(boolean indexable, String operator) {
            this.indexable = indexable;
            this.operator = operator;
        }

        public boolean isComparison() {
            return this.isAscending() || this.isDescending();
        }

        public boolean isEquality() {
            return this == EQUAL || this == NOT_EQUAL;
        }

        public boolean isAscending() {
            return this == GREATER_THAN || this == GREATER_OR_EQUAL;
        }

        public boolean isDescending() {
            return this == LESS_THAN || this == LESS_OR_EQUAL;
        }

        public boolean isIndexable() {
            return this.indexable;
        }

        public String getOperator() {
            return this.operator;
        }

        public boolean isIndexableForNode(short nodeType, IndexableConstraint constraint, RuleBaseConfiguration config) {
            switch (this) {
                case EQUAL: {
                    return true;
                }
                case NOT_EQUAL: 
                case UNKNOWN: {
                    return false;
                }
            }
            return IndexUtil.canHaveRangeIndex(nodeType, constraint, config);
        }

        public ConstraintType negate() {
            switch (this) {
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_THAN;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case LESS_THAN: {
                    return GREATER_OR_EQUAL;
                }
            }
            return UNKNOWN;
        }

        public boolean canInverse() {
            switch (this) {
                case EQUAL: 
                case NOT_EQUAL: 
                case GREATER_THAN: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: 
                case LESS_THAN: {
                    return true;
                }
            }
            return false;
        }

        public ConstraintType inverse() {
            switch (this) {
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_OR_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_OR_EQUAL;
                }
            }
            return this;
        }

        public static ConstraintType decode(String operator) {
            return ConstraintType.decode(operator, false);
        }

        public static ConstraintType decode(String operator, boolean negated) {
            for (ConstraintType c : ConstraintType.values()) {
                if (c.getOperator() == null || !c.getOperator().equals(operator)) continue;
                return negated ? c.negate() : c;
            }
            return UNKNOWN;
        }

        public static ConstraintType getType(Constraint constraint) {
            return constraint instanceof IndexableConstraint ? ((IndexableConstraint)constraint).getConstraintType() : UNKNOWN;
        }
    }
}

