/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Reoccurring;
import org.kie.api.executor.STATUS;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ExecutionErrorInfoDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.RequestInfoLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.kie.internal.task.query.AuditTaskDeleteBuilder;
import org.kie.internal.task.query.TaskEventDeleteBuilder;
import org.kie.internal.task.query.TaskVariableDeleteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCleanupCommand
implements Command,
Reoccurring {
    private static final Logger logger = LoggerFactory.getLogger(LogCleanupCommand.class);
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final String RECORDS_PER_TRANSACTION = "RecordsPerTransaction";
    private long nextScheduleTimeAdd;
    private boolean mightBeMore;

    public Date getScheduleTime() {
        Date nextSchedule;
        if (this.mightBeMore) {
            nextSchedule = Date.from(Instant.now().plus(Duration.ofMillis(100L)));
        } else {
            if (this.nextScheduleTimeAdd <= 0L) {
                return null;
            }
            nextSchedule = Date.from(Instant.now().plus(this.nextScheduleTimeAdd, ChronoUnit.MILLIS));
        }
        logger.debug("Next schedule for job {} is set to {}", (Object)this.getClass().getSimpleName(), (Object)nextSchedule);
        return nextSchedule;
    }

    protected int readInt(Map<String, Object> params, String propName, int defaultValue) {
        Object value = params.get(propName);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        boolean skipProcessLog = ctx.getData().containsKey("SkipProcessLog") ? Boolean.parseBoolean((String)ctx.getData("SkipProcessLog")) : false;
        boolean skipTaskLog = ctx.getData().containsKey("SkipTaskLog") ? Boolean.parseBoolean((String)ctx.getData("SkipTaskLog")) : false;
        boolean skipExecutorLog = ctx.getData().containsKey("SkipExecutorLog") ? Boolean.parseBoolean((String)ctx.getData("SkipExecutorLog")) : false;
        int recordsPerTransaction = this.readInt(ctx.getData(), RECORDS_PER_TRANSACTION, 0);
        this.mightBeMore = false;
        SimpleDateFormat formatToUse = this.dateFormat;
        String dataFormat = (String)ctx.getData("DateFormat");
        if (dataFormat != null) {
            formatToUse = new SimpleDateFormat(dataFormat);
        }
        ExecutionResults executionResults = new ExecutionResults();
        String emfName = (String)ctx.getData("EmfName");
        if (emfName == null) {
            emfName = "org.jbpm.domain";
        }
        this.nextScheduleTimeAdd = TimeUnit.DAYS.toMillis(1L);
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(emfName);
        ExecutorJPAAuditService auditLogService = new ExecutorJPAAuditService(emf);
        String olderThan = (String)ctx.getData("OlderThan");
        String olderThanPeriod = (String)ctx.getData("OlderThanPeriod");
        String forProcess = (String)ctx.getData("ForProcess");
        String forDeployment = (String)ctx.getData("ForDeployment");
        String statusFilter = (String)ctx.getData("Status");
        Integer[] status = null;
        if (statusFilter != null) {
            status = (Integer[])Arrays.stream(statusFilter.split(",")).map(e -> Integer.parseInt(e)).toArray(Integer[]::new);
        }
        if (olderThanPeriod != null) {
            long olderThanDuration = DateTimeUtils.parseDateAsDuration((String)olderThanPeriod);
            Date olderThanDate = new Date(System.currentTimeMillis() - olderThanDuration);
            olderThan = formatToUse.format(olderThanDate);
        }
        if (!skipExecutorLog) {
            int errorInfoLogsRemoved = ((ErrorInfoDeleteBuilder)((ErrorInfoDeleteBuilder)((ErrorInfoDeleteBuilder)auditLogService.errorInfoLogDeleteBuilder().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(errorInfoLogsRemoved, recordsPerTransaction);
            logger.info("ErrorInfoLogsRemoved {}", (Object)errorInfoLogsRemoved);
            executionResults.setData("ErrorInfoLogsRemoved", (Object)errorInfoLogsRemoved);
            int requestInfoLogsRemoved = ((RequestInfoLogDeleteBuilder)((RequestInfoLogDeleteBuilder)((RequestInfoLogDeleteBuilder)auditLogService.requestInfoLogDeleteBuilder().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).logBelongsToProcessInStatus(status)).status(new STATUS[]{STATUS.CANCELLED, STATUS.DONE, STATUS.ERROR}).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(requestInfoLogsRemoved, recordsPerTransaction);
            logger.info("RequestInfoLogsRemoved {}", (Object)requestInfoLogsRemoved);
            executionResults.setData("RequestInfoLogsRemoved", (Object)requestInfoLogsRemoved);
            int executionErrorInfoLogsRemoved = ((ExecutionErrorInfoDeleteBuilder)((ExecutionErrorInfoDeleteBuilder)((ExecutionErrorInfoDeleteBuilder)auditLogService.executionErrorInfoDeleteBuilder().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(executionErrorInfoLogsRemoved, recordsPerTransaction);
            logger.info("ExecutionErrorInfoLogsRemoved {}", (Object)executionErrorInfoLogsRemoved);
            executionResults.setData("ExecutionErrorInfoLogsRemoved", (Object)executionErrorInfoLogsRemoved);
        }
        if (!skipTaskLog) {
            int taLogsRemoved = ((AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)auditLogService.auditTaskDelete().processId(new String[]{forProcess})).dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).deploymentId(new String[]{forDeployment}).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(taLogsRemoved, recordsPerTransaction);
            logger.info("TaskAuditLogRemoved {}", (Object)taLogsRemoved);
            executionResults.setData("TaskAuditLogRemoved", (Object)taLogsRemoved);
            int teLogsRemoved = ((TaskEventDeleteBuilder)((TaskEventDeleteBuilder)((TaskEventDeleteBuilder)auditLogService.taskEventInstanceLogDelete().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(teLogsRemoved, recordsPerTransaction);
            logger.info("TaskEventLogRemoved {}", (Object)teLogsRemoved);
            executionResults.setData("TaskEventLogRemoved", (Object)teLogsRemoved);
            int tvLogsRemoved = ((TaskVariableDeleteBuilder)((TaskVariableDeleteBuilder)((TaskVariableDeleteBuilder)auditLogService.taskVariableInstanceLogDelete().dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(tvLogsRemoved, recordsPerTransaction);
            logger.info("TaskVariableLogRemoved {}", (Object)tvLogsRemoved);
            executionResults.setData("TaskVariableLogRemoved", (Object)tvLogsRemoved);
        }
        if (!skipProcessLog) {
            int niLogsRemoved = ((NodeInstanceLogDeleteBuilder)((NodeInstanceLogDeleteBuilder)((NodeInstanceLogDeleteBuilder)((NodeInstanceLogDeleteBuilder)auditLogService.nodeInstanceLogDelete().processId(new String[]{forProcess})).dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).externalId(new String[]{forDeployment}).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(niLogsRemoved, recordsPerTransaction);
            logger.info("NodeInstanceLogRemoved {}", (Object)niLogsRemoved);
            executionResults.setData("NodeInstanceLogRemoved", (Object)niLogsRemoved);
            int viLogsRemoved = ((VariableInstanceLogDeleteBuilder)((VariableInstanceLogDeleteBuilder)((VariableInstanceLogDeleteBuilder)((VariableInstanceLogDeleteBuilder)auditLogService.variableInstanceLogDelete().processId(new String[]{forProcess})).dateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan))).recordsPerTransaction(recordsPerTransaction)).externalId(new String[]{forDeployment}).logBelongsToProcessInStatus(status)).build().execute();
            this.mightBeMore |= LogCleanupCommand.mightBeMore(viLogsRemoved, recordsPerTransaction);
            logger.info("VariableInstanceLogRemoved {}", (Object)viLogsRemoved);
            executionResults.setData("VariableInstanceLogRemoved", (Object)viLogsRemoved);
            if (!this.mightBeMore) {
                int piLogsRemoved = ((ProcessInstanceLogDeleteBuilder)((ProcessInstanceLogDeleteBuilder)((ProcessInstanceLogDeleteBuilder)auditLogService.processInstanceLogDelete().processId(new String[]{forProcess})).status(new int[]{2, 3}).endDateRangeEnd(olderThan == null ? null : formatToUse.parse(olderThan)).recordsPerTransaction(recordsPerTransaction)).externalId(new String[]{forDeployment}).logBelongsToProcessInStatus(status)).build().execute();
                this.mightBeMore |= LogCleanupCommand.mightBeMore(piLogsRemoved, recordsPerTransaction);
                logger.info("ProcessInstanceLogRemoved {}", (Object)piLogsRemoved);
                executionResults.setData("ProcessInstanceLogRemoved", (Object)piLogsRemoved);
            }
        }
        this.calculateNextRun(ctx);
        executionResults.setData("BAMLogRemoved", (Object)0L);
        return executionResults;
    }

    private static boolean mightBeMore(int deleted, int recordPerTransaction) {
        return recordPerTransaction > 0 && deleted >= recordPerTransaction;
    }

    private void calculateNextRun(CommandContext ctx) {
        String singleRun = (String)ctx.getData("SingleRun");
        if ("true".equalsIgnoreCase(singleRun)) {
            this.nextScheduleTimeAdd = -1L;
            return;
        }
        String nextRun = (String)ctx.getData("NextRun");
        if (nextRun != null) {
            this.nextScheduleTimeAdd = Math.max(DateTimeUtils.parseDateAsDuration((String)nextRun) - this.calculateExecutionTimeInMillis(ctx), 100L);
        }
    }

    private long calculateExecutionTimeInMillis(CommandContext ctx) {
        long executionTimeInMillis = 0L;
        String repeatMode = (String)ctx.getData("RepeatMode");
        if ("fixed".equalsIgnoreCase(repeatMode)) {
            Date scheduledExecutionTime = (Date)ctx.getData("scheduledExecutionTime");
            executionTimeInMillis = Instant.now().minus(scheduledExecutionTime.toInstant().toEpochMilli(), ChronoUnit.MILLIS).toEpochMilli();
            logger.debug("Calculated execution time {}ms, based on scheduled execution time {}", (Object)executionTimeInMillis, (Object)scheduledExecutionTime);
        }
        return executionTimeInMillis;
    }
}

