/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.JobNameHelper;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.jpa.TimerMappingInfo;
import org.jbpm.services.ejb.timer.EJBTimerScheduler;
import org.jbpm.services.ejb.timer.EjbGlobalJobHandle;
import org.jbpm.services.ejb.timer.EjbTimerJob;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbSchedulerService
implements GlobalSchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(EjbSchedulerService.class);
    private AtomicLong idCounter = new AtomicLong();
    private GlobalTimerService globalTimerService;
    private EJBTimerScheduler scheduler;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor((GlobalSchedulerService)this);

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        long id = this.idCounter.getAndIncrement();
        String jobName = this.getJobName(ctx, id);
        EjbGlobalJobHandle jobHandle = new EjbGlobalJobHandle(id, jobName, this.globalTimerService.getTimerServiceId());
        TimerJobInstance jobInstance = null;
        if (!ctx.isNew()) {
            jobInstance = this.getTimerJobInstance(jobName);
            if (jobInstance == null) {
                jobInstance = this.scheduler.getTimerByName(jobName);
            }
            if (jobInstance != null) {
                return jobInstance.getJobHandle();
            }
        }
        jobInstance = this.globalTimerService.getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, (InternalSchedulerService)this.globalTimerService);
        jobHandle.setTimerJobInstance(jobInstance);
        this.interceptor.internalSchedule(jobInstance);
        return jobHandle;
    }

    public boolean removeJob(JobHandle jobHandle) {
        String uuid = ((EjbGlobalJobHandle)jobHandle).getUuid();
        Timer ejbTimer = this.getEjbTimer(this.getTimerMappinInfo(uuid));
        boolean result = this.scheduler.removeJob(jobHandle, ejbTimer);
        logger.debug("Remove job returned {}", (Object)result);
        return result;
    }

    private TimerJobInstance getTimerJobInstance(String uuid) {
        return this.unwrapTimerJobInstance(this.getEjbTimer(this.getTimerMappinInfo(uuid)));
    }

    public TimerJobInstance getTimerJobInstance(long processInstanceId, long timerId) {
        return this.unwrapTimerJobInstance(this.getEjbTimer(this.getTimerMappinInfo(processInstanceId, timerId)));
    }

    private Timer getEjbTimer(TimerMappingInfo timerMappingInfo) {
        try {
            if (timerMappingInfo == null || timerMappingInfo.getInfo() == null) {
                return null;
            }
            return ((TimerHandle)new ObjectInputStream(new ByteArrayInputStream(timerMappingInfo.getInfo())).readObject()).getTimer();
        }
        catch (Exception e) {
            logger.warn("Problem retrieving timer for uuid {}", (Object)timerMappingInfo.getUuid(), (Object)e);
            return null;
        }
    }

    private TimerMappingInfo getTimerMappinInfo(String uuid) {
        return this.getTimerMappingInfo(em -> em.createQuery("SELECT o FROM TimerMappingInfo o WHERE o.uuid = :uuid", TimerMappingInfo.class).setParameter("uuid", (Object)uuid).getResultList());
    }

    private TimerMappingInfo getTimerMappinInfo(long processInstanceId, long timerId) {
        return this.getTimerMappingInfo(em -> em.createQuery("SELECT o FROM TimerMappingInfo o WHERE o.timerId = :timerId AND o.processInstanceId = :processInstanceId", TimerMappingInfo.class).setParameter("processInstanceId", (Object)processInstanceId).setParameter("timerId", (Object)timerId).getResultList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerMappingInfo getTimerMappingInfo(Function<EntityManager, List<TimerMappingInfo>> func) {
        try (EntityManager em = EntityManagerFactoryManager.get().getOrCreate(this.globalTimerService.getRuntimeManager().getDeploymentDescriptor().getPersistenceUnit()).createEntityManager();){
            List<TimerMappingInfo> info = func.apply(em);
            TimerMappingInfo timerMappingInfo = !info.isEmpty() ? info.get(0) : null;
            return timerMappingInfo;
        }
    }

    private TimerJobInstance unwrapTimerJobInstance(Timer timer) {
        try {
            if (timer == null) {
                return null;
            }
            Serializable info = timer.getInfo();
            EjbTimerJob job = (EjbTimerJob)info;
            TimerJobInstance handle = job.getTimerJobInstance();
            return handle;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void invalidate(JobHandle jobHandle) {
        this.scheduler.evictCache(jobHandle);
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        this.scheduler.internalSchedule(timerJobInstance);
    }

    public void initScheduler(TimerService timerService) {
        this.globalTimerService = (GlobalTimerService)timerService;
        try {
            this.scheduler = (EJBTimerScheduler)InitialContext.doLookup("java:module/EJBTimerScheduler");
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to find EJB scheduler for jBPM timer service", e);
        }
    }

    public void shutdown() {
    }

    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return new EjbGlobalJobHandle(-1L, this.getJobName((JobContext)ctx, -1L), this.globalTimerService.getTimerServiceId());
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean retryEnabled() {
        return false;
    }

    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        return true;
    }

    protected String getJobName(JobContext ctx, long id) {
        return JobNameHelper.getJobName((JobContext)ctx, (long)id);
    }

    public void setEnvironment(RuntimeEnvironment environment) {
        if (environment instanceof SimpleRuntimeEnvironment) {
            ((SimpleRuntimeEnvironment)environment).addToEnvironment("IS_TIMER_CMT", (Object)true);
        }
    }
}

